typedef unsigned char cfg_u8;
typedef union {
    struct {
        cfg_u8 offset;
        cfg_u8 value;
    };
    struct {
        cfg_u8 command;
        cfg_u8 param;
    };
} cfg_reg;

#define CFG_META_SWITCH (255)
#define CFG_META_DELAY  (254)
#define CFG_META_BURST  (253)

/* Example C code */
/*
    // Externally implemented function that can write n-bytes to the device
    // PCM51xx and TAS5766 targets require the high bit (0x80) of the I2C register to be set on multiple writes.
    // Refer to the device data sheet for more information.
    extern int i2c_write(unsigned char *data, int n);
    // Externally implemented function that delays execution by n milliseconds
    extern int delay(int n);
    // Example implementation.  Call like:
    //     transmit_registers(registers, sizeof(registers)/sizeof(registers[0]));
    void transmit_registers(cfg_reg *r, int n)
    {
        int i = 0;
        while (i < n) {
            switch (r[i].command) {
            case CFG_META_SWITCH:
                // Used in legacy applications.  Ignored here.
                break;
            case CFG_META_DELAY:
                delay(r[i].param);
                break;
            case CFG_META_BURST:
                i2c_write((unsigned char *)&r[i+1], r[i].param);
                i +=  (r[i].param / 2) + 1;
                break;
            default:
                i2c_write((unsigned char *)&r[i], 1);
                break;
            }
            i++;
        }
    }
*/

cfg_reg registers[] = {
    { 0x00, 0x00 },
    { 0x7f, 0x00 },
    { 0x00, 0x01 },
    { 0x02, 0x20 },
    { 0x00, 0x00 },
    { 0x7f, 0x8c },
    { 0x00, 0x01 },
    { CFG_META_BURST, 44 },
    { 0x08, 0x00 },
    { 0xfe, 0x20 },
    { 0x24, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x50 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x50 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x40 },
    { 0x00, 0x00 },
    { 0xfc, 0x50 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 72 },
    { 0x38, 0x00 },
    { 0xfe, 0x20 },
    { 0x08, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x40 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x40 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x40 },
    { 0x00, 0x00 },
    { 0xfc, 0x50 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0x50, 0x08 },
    { 0x29, 0x00 },
    { 0xfe, 0x14 },
    { 0xd6, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x02 },
    { CFG_META_BURST, 112 },
    { 0x10, 0x00 },
    { 0xfe, 0x20 },
    { 0x18, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0x30, 0x00 },
    { 0x02, 0x02 },
    { 0x38, 0x00 },
    { 0x02, 0x02 },
    { 0x18, 0x09 },
    { 0xdf, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x8f },
    { 0x00, 0xff },
    { 0xd3, 0x02 },
    { 0xc0, 0x00 },
    { 0x01, 0x02 },
    { 0xc8, 0x00 },
    { 0x00, 0x00 },
    { 0xbe, 0x20 },
    { 0x2e, 0x08 },
    { 0xfc, 0x03 },
    { 0xfa, 0x02 },
    { 0xc8, 0x00 },
    { 0x01, 0x08 },
    { 0x00, 0x10 },
    { 0x20, 0x08 },
    { 0x20, 0x46 },
    { 0x50, 0x00 },
    { 0xff, 0x24 },
    { 0x58, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x8c },
    { 0xff, 0x08 },
    { 0x24, 0x84 },
    { 0xc0, 0x01 },
    { 0x04, 0x84 },
    { 0xc2, 0x04 },
    { 0x0c, 0x02 },
    { 0xc0, 0x06 },
    { 0x00, 0x84 },
    { 0xc3, 0x06 },
    { 0x93, 0x02 },
    { 0x40, 0x00 },
    { 0x76, 0x00 },
    { 0xff, 0x08 },
    { 0xd6, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x85 },
    { 0x42, 0x00 },
    { 0x80, 0x08 },
    { 0x04, 0x00 },
    { 0x02, 0x00 },
    { 0x00, 0x03 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x08 },
    { 0x00, 0x10 },
    { 0x40, 0x08 },
    { 0x01, 0x00 },
    { 0x02, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x20 },
    { 0x48, 0x84 },
    { 0xd3, 0x00 },
    { 0x8c, 0x02 },
    { 0x28, 0x00 },
    { 0x4c, 0x8e },
    { 0xfd, 0x00 },
    { 0x57, 0x84 },
    { 0x80, 0x02 },
    { 0x00, 0x86 },
    { 0x83, 0x00 },
    { 0x57, 0x02 },
    { 0xd0, 0x00 },
    { 0x00, 0x86 },
    { 0xd2, 0x21 },
    { 0x01, 0x86 },
    { 0xd2, 0x21 },
    { 0x02, 0x02 },
    { 0x28, 0x00 },
    { 0x78, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0x80, 0x02 },
    { 0x00, 0x02 },
    { 0xd3, 0x00 },
    { 0x10, 0x08 },
    { 0xfc, 0x00 },
    { 0x50, 0x08 },
    { 0xfc, 0x0b },
    { 0x98, 0x08 },
    { 0x00, 0x10 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x20 },
    { 0x5d, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x08 },
    { 0x00, 0x30 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x20 },
    { 0x5b, 0x02 },
    { 0xc0, 0x00 },
    { 0x03, 0x02 },
    { 0xc0, 0x00 },
    { 0x01, 0x00 },
    { 0xfe, 0x20 },
    { 0x5f, 0x00 },
    { 0x00, 0x04 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x86 },
    { 0xc3, 0x00 },
    { 0x7d, 0x00 },
    { 0xfe, 0x20 },
    { 0x5f, 0x86 },
    { 0xc3, 0x00 },
    { 0x7d, 0x02 },
    { 0xc0, 0x00 },
    { 0x06, 0x86 },
    { 0xc3, 0x00 },
    { 0x7d, 0x8c },
    { 0xff, 0x00 },
    { 0x47, 0x02 },
    { 0xc0, 0x00 },
    { 0x00, 0x04 },
    { 0x20, 0x11 },
    { 0x44, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x20 },
    { 0x6d, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0x48, 0x04 },
    { 0x0c, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0xd0, 0x03 },
    { 0x88, 0x84 },
    { 0xc2, 0x21 },
    { 0x1f, 0x84 },
    { 0xd2, 0x21 },
    { 0x00, 0x02 },
    { 0xc0, 0x04 },
    { 0x08, 0x84 },
    { 0xc2, 0x21 },
    { 0x06, 0x00 },
    { 0xff, 0x23 },
    { 0x89, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xff, 0x20 },
    { 0x04, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xff, 0x23 },
    { 0xf8, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0x40, 0x08 },
    { 0x24, 0x00 },
    { 0xff, 0x01 },
    { 0xce, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0x40, 0x08 },
    { 0x24, 0x00 },
    { 0xff, 0x01 },
    { 0xff, 0x00 },
    { 0x00, 0x05 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0xc0, 0x00 },
    { 0x01, 0x08 },
    { 0xfc, 0x04 },
    { 0x38, 0x84 },
    { 0xc2, 0x04 },
    { 0x0c, 0x00 },
    { 0xff, 0x20 },
    { 0x06, 0x00 },
    { 0xfc, 0x40 },
    { 0x00, 0x02 },
    { 0xc0, 0x00 },
    { 0x00, 0x8c },
    { 0xff, 0x00 },
    { 0x47, 0x04 },
    { 0x20, 0x11 },
    { 0x44, 0x84 },
    { 0xd9, 0x00 },
    { 0x3f, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0x48, 0x02 },
    { 0x78, 0x02 },
    { 0x60, 0x00 },
    { 0x01, 0x00 },
    { 0x22, 0x20 },
    { 0x94, 0x8c },
    { 0xff, 0x01 },
    { 0xc0, 0x08 },
    { 0xfc, 0x64 },
    { 0x9a, 0x02 },
    { 0x68, 0x00 },
    { 0x02, 0x02 },
    { 0x73, 0x00 },
    { 0x1a, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0x84, 0x0d },
    { 0x00, 0x00 },
    { 0x00, 0x8e },
    { 0x04, 0x84 },
    { 0xd0, 0x01 },
    { 0x01, 0x84 },
    { 0xc8, 0x0b },
    { 0x00, 0x08 },
    { 0xfc, 0x48 },
    { 0x3a, 0x08 },
    { 0xfc, 0x28 },
    { 0x39, 0x10 },
    { 0x00, 0x12 },
    { 0x05, 0x00 },
    { 0xfe, 0x20 },
    { 0x9d, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x08 },
    { 0x00, 0x10 },
    { 0x60, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x06 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x22, 0x20 },
    { 0x9a, 0x02 },
    { 0x40, 0x01 },
    { 0xc8, 0x02 },
    { 0x40, 0x01 },
    { 0xc0, 0x00 },
    { 0x00, 0x8e },
    { 0x01, 0x84 },
    { 0xd0, 0x09 },
    { 0x00, 0x84 },
    { 0xd2, 0x29 },
    { 0x00, 0x08 },
    { 0xfc, 0x64 },
    { 0xda, 0x8c },
    { 0xff, 0x02 },
    { 0x80, 0x02 },
    { 0x73, 0x00 },
    { 0x1a, 0x02 },
    { 0x48, 0x00 },
    { 0xdd, 0x02 },
    { 0x68, 0x00 },
    { 0x08, 0x84 },
    { 0x84, 0x0d },
    { 0x00, 0x10 },
    { 0x18, 0xa1 },
    { 0x00, 0x08 },
    { 0x00, 0x10 },
    { 0x40, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x20 },
    { 0xf8, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x08 },
    { 0x00, 0x30 },
    { 0x40, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x20 },
    { 0xf1, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x08 },
    { 0x00, 0x50 },
    { 0x40, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x20 },
    { 0xea, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x08 },
    { 0x00, 0x70 },
    { 0x40, 0x00 },
    { 0x00, 0x07 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x20 },
    { 0xe3, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x08 },
    { 0x00, 0xd0 },
    { 0x40, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x20 },
    { 0xdc, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x08 },
    { 0x00, 0xf0 },
    { 0x40, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x20 },
    { 0xd5, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x08 },
    { 0x01, 0x10 },
    { 0x40, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x20 },
    { 0xce, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x8f },
    { 0x50, 0x00 },
    { 0x15, 0x8f },
    { 0x38, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x8e },
    { 0x01, 0x84 },
    { 0xd0, 0x49 },
    { 0x00, 0x84 },
    { 0xd2, 0x6b },
    { 0x00, 0x00 },
    { 0xfe, 0x20 },
    { 0xfd, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0x50, 0x01 },
    { 0xf8, 0x8f },
    { 0x38, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x8e },
    { 0x01, 0x84 },
    { 0xd0, 0x49 },
    { 0x00, 0x00 },
    { 0x00, 0x08 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x84 },
    { 0xd2, 0x6b },
    { 0x00, 0x00 },
    { 0xfe, 0x20 },
    { 0xfd, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0x50, 0x01 },
    { 0xf0, 0x8f },
    { 0x38, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x8e },
    { 0x01, 0x84 },
    { 0xd0, 0x49 },
    { 0x00, 0x84 },
    { 0xd2, 0x6b },
    { 0x00, 0x00 },
    { 0xfe, 0x20 },
    { 0xfd, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x8f },
    { 0x50, 0x00 },
    { 0x25, 0x8f },
    { 0x38, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x8e },
    { 0x01, 0x84 },
    { 0xd0, 0x49 },
    { 0x00, 0x84 },
    { 0xd2, 0x6b },
    { 0x00, 0x00 },
    { 0xfe, 0x20 },
    { 0xfd, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0x50, 0x00 },
    { 0x8f, 0x8f },
    { 0x38, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x8e },
    { 0x01, 0x10 },
    { 0x18, 0xc1 },
    { 0x00, 0x84 },
    { 0xd2, 0x6b },
    { 0x00, 0x00 },
    { 0xfe, 0x20 },
    { 0xfd, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0x50, 0x06 },
    { 0xbb, 0x8f },
    { 0x38, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x8e },
    { 0x01, 0x84 },
    { 0xd0, 0x49 },
    { 0x00, 0x84 },
    { 0xd2, 0x6b },
    { 0x00, 0x00 },
    { 0xfe, 0x20 },
    { 0xfd, 0x00 },
    { 0x00, 0x09 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x8f },
    { 0x50, 0x00 },
    { 0x1d, 0x8f },
    { 0x38, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x8e },
    { 0x01, 0x84 },
    { 0xd0, 0x49 },
    { 0x00, 0x84 },
    { 0xd2, 0x6b },
    { 0x00, 0x00 },
    { 0xfe, 0x20 },
    { 0xfd, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x8f },
    { 0x50, 0x00 },
    { 0x15, 0x8f },
    { 0x38, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x8e },
    { 0x01, 0x84 },
    { 0xd0, 0x49 },
    { 0x00, 0x84 },
    { 0xd2, 0x6b },
    { 0x00, 0x08 },
    { 0x00, 0x2c },
    { 0x00, 0x08 },
    { 0x00, 0x50 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x62, 0x20 },
    { 0xa3, 0x8f },
    { 0x20, 0x00 },
    { 0x01, 0x86 },
    { 0xa1, 0x00 },
    { 0x98, 0x02 },
    { 0x48, 0x02 },
    { 0x78, 0x02 },
    { 0x50, 0x06 },
    { 0xbb, 0x02 },
    { 0x40, 0x02 },
    { 0x78, 0x00 },
    { 0x00, 0x8e },
    { 0x02, 0xe0 },
    { 0x20, 0x00 },
    { 0x00, 0x80 },
    { 0x07, 0x00 },
    { 0x64, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x86 },
    { 0xc1, 0x00 },
    { 0x7d, 0x08 },
    { 0x00, 0x70 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x0a },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x21 },
    { 0x21, 0x8c },
    { 0xff, 0x02 },
    { 0x78, 0x08 },
    { 0x00, 0xd0 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x21 },
    { 0x1b, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x8e },
    { 0x01, 0x84 },
    { 0xc0, 0x29 },
    { 0x00, 0x84 },
    { 0xc2, 0x49 },
    { 0x00, 0x00 },
    { 0xfe, 0x21 },
    { 0x26, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0x40, 0x00 },
    { 0x15, 0x02 },
    { 0x48, 0x02 },
    { 0x78, 0x00 },
    { 0xff, 0x02 },
    { 0xf9, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfe, 0x21 },
    { 0x26, 0x02 },
    { 0x40, 0x02 },
    { 0x78, 0x02 },
    { 0x40, 0x00 },
    { 0x16, 0x02 },
    { 0x48, 0x02 },
    { 0x78, 0x00 },
    { 0xff, 0x02 },
    { 0xd8, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0x40, 0x02 },
    { 0x78, 0x02 },
    { 0x48, 0x00 },
    { 0x17, 0x02 },
    { 0xc0, 0x00 },
    { 0x08, 0x04 },
    { 0x60, 0x00 },
    { 0x14, 0x08 },
    { 0x00, 0x10 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x0b },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x22, 0x22 },
    { 0x20, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0x48, 0x02 },
    { 0x44, 0x84 },
    { 0x4a, 0x04 },
    { 0x0e, 0x02 },
    { 0xc0, 0x06 },
    { 0xbb, 0x84 },
    { 0xc2, 0x04 },
    { 0x0d, 0x02 },
    { 0x58, 0x02 },
    { 0x74, 0x02 },
    { 0x48, 0x00 },
    { 0x7d, 0x02 },
    { 0x40, 0x04 },
    { 0x00, 0x00 },
    { 0xfe, 0x22 },
    { 0x06, 0x02 },
    { 0xc0, 0x00 },
    { 0x00, 0x84 },
    { 0xc1, 0x00 },
    { 0x3e, 0x08 },
    { 0xfc, 0x04 },
    { 0xd8, 0x84 },
    { 0x5a, 0x04 },
    { 0x10, 0x02 },
    { 0x50, 0x02 },
    { 0x00, 0x02 },
    { 0x63, 0x00 },
    { 0x18, 0x02 },
    { 0x48, 0x01 },
    { 0xf0, 0x00 },
    { 0xff, 0x00 },
    { 0xee, 0x84 },
    { 0x84, 0x09 },
    { 0x00, 0x02 },
    { 0x40, 0x01 },
    { 0xf0, 0x02 },
    { 0x48, 0x00 },
    { 0x4f, 0x02 },
    { 0x50, 0x00 },
    { 0x18, 0x00 },
    { 0xff, 0x01 },
    { 0x52, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0x48, 0x04 },
    { 0x0d, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xff, 0x24 },
    { 0x15, 0x8f },
    { 0x60, 0x00 },
    { 0x00, 0x02 },
    { 0x48, 0x00 },
    { 0x1f, 0x02 },
    { 0xd0, 0x00 },
    { 0x1a, 0x00 },
    { 0x00, 0x0c },
    { CFG_META_BURST, 120 },
    { 0x08, 0x02 },
    { 0xc8, 0x00 },
    { 0x00, 0x84 },
    { 0x50, 0x04 },
    { 0x0d, 0x84 },
    { 0x52, 0x04 },
    { 0x11, 0x84 },
    { 0xca, 0x04 },
    { 0x12, 0x02 },
    { 0x40, 0x00 },
    { 0x99, 0x84 },
    { 0xc0, 0x41 },
    { 0x00, 0x00 },
    { 0xff, 0x14 },
    { 0x64, 0x02 },
    { 0xc8, 0x00 },
    { 0x0c, 0x84 },
    { 0xd0, 0x04 },
    { 0x12, 0x08 },
    { 0x00, 0x2c },
    { 0x41, 0x84 },
    { 0x50, 0x04 },
    { 0x11, 0x08 },
    { 0x01, 0x10 },
    { 0x20, 0x02 },
    { 0x60, 0x00 },
    { 0x01, 0xe0 },
    { 0x10, 0x10 },
    { 0x97, 0x80 },
    { 0x07, 0xa0 },
    { 0x66, 0x02 },
    { 0xd0, 0x00 },
    { 0x1a, 0x00 },
    { 0x62, 0x21 },
    { 0x4c, 0x02 },
    { 0x48, 0x00 },
    { 0x1f, 0x02 },
    { 0xd0, 0x00 },
    { 0x00, 0x8c },
    { 0xff, 0x02 },
    { 0x13, 0x06 },
    { 0x20, 0x11 },
    { 0x14, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x21 },
    { 0x98, 0x84 },
    { 0x52, 0x04 },
    { 0x11, 0x84 },
    { 0x50, 0x04 },
    { 0x0d, 0x84 },
    { 0x52, 0x04 },
    { 0x0d, 0x84 },
    { 0xd2, 0x04 },
    { 0x12, 0x02 },
    { 0x48, 0x00 },
    { 0x25, 0x02 },
    { 0x40, 0x01 },
    { 0xeb, 0x00 },
    { 0x00, 0x0d },
    { CFG_META_BURST, 120 },
    { 0x08, 0x84 },
    { 0xc0, 0x41 },
    { 0x00, 0x00 },
    { 0xff, 0x14 },
    { 0x90, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0x50, 0x04 },
    { 0x0d, 0x84 },
    { 0xc2, 0x04 },
    { 0x13, 0x02 },
    { 0x48, 0x00 },
    { 0x26, 0x02 },
    { 0x40, 0x01 },
    { 0xf5, 0x84 },
    { 0xc0, 0x41 },
    { 0x00, 0x00 },
    { 0xff, 0x14 },
    { 0xa0, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0x50, 0x04 },
    { 0x0d, 0x84 },
    { 0xc2, 0x04 },
    { 0x14, 0x02 },
    { 0x48, 0x00 },
    { 0x27, 0x02 },
    { 0x40, 0x02 },
    { 0x09, 0x84 },
    { 0xc0, 0x41 },
    { 0x00, 0x00 },
    { 0xff, 0x14 },
    { 0x90, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0xd3, 0x00 },
    { 0x18, 0x84 },
    { 0xc0, 0x04 },
    { 0x13, 0x84 },
    { 0xd2, 0x04 },
    { 0x13, 0x02 },
    { 0x40, 0x00 },
    { 0xa9, 0x02 },
    { 0x48, 0x02 },
    { 0x17, 0x00 },
    { 0xff, 0x13 },
    { 0xfc, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0xd3, 0x00 },
    { 0x18, 0x84 },
    { 0xc0, 0x04 },
    { 0x14, 0x84 },
    { 0xd2, 0x04 },
    { 0x14, 0x02 },
    { 0x40, 0x02 },
    { 0x3a, 0x02 },
    { 0x48, 0x02 },
    { 0x26, 0x00 },
    { 0xff, 0x13 },
    { 0xfc, 0x00 },
    { 0x00, 0x0e },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0xd3, 0x00 },
    { 0x18, 0x84 },
    { 0xc0, 0x04 },
    { 0x13, 0x84 },
    { 0xd2, 0x04 },
    { 0x13, 0x02 },
    { 0x40, 0x02 },
    { 0x5a, 0x02 },
    { 0x48, 0x02 },
    { 0x35, 0x00 },
    { 0xff, 0x13 },
    { 0xfc, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0xd0, 0x04 },
    { 0x12, 0x08 },
    { 0x00, 0x2c },
    { 0x42, 0xe0 },
    { 0x82, 0x92 },
    { 0x14, 0x08 },
    { 0x01, 0x10 },
    { 0x40, 0xf0 },
    { 0x82, 0x72 },
    { 0x15, 0x84 },
    { 0x50, 0x04 },
    { 0x0d, 0xf0 },
    { 0x10, 0x12 },
    { 0x16, 0x02 },
    { 0x60, 0x00 },
    { 0x01, 0x00 },
    { 0x62, 0x21 },
    { 0x64, 0x88 },
    { 0x07, 0x40 },
    { 0x66, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0x48, 0x04 },
    { 0x11, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x8f },
    { 0x68, 0xff },
    { 0xf8, 0x84 },
    { 0x4a, 0x04 },
    { 0x0d, 0x00 },
    { 0xff, 0x23 },
    { 0xe7, 0x8f },
    { 0x60, 0x00 },
    { 0x00, 0x84 },
    { 0xc1, 0x00 },
    { 0x3f, 0x08 },
    { 0xfc, 0x04 },
    { 0x58, 0x8c },
    { 0xff, 0x00 },
    { 0xda, 0x02 },
    { 0x63, 0x00 },
    { 0x18, 0x00 },
    { 0x00, 0x0f },
    { CFG_META_BURST, 120 },
    { 0x08, 0x02 },
    { 0xd0, 0x00 },
    { 0x00, 0x06 },
    { 0x20, 0x11 },
    { 0x14, 0x8c },
    { 0xff, 0x01 },
    { 0xb8, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x22, 0x21 },
    { 0xb0, 0x84 },
    { 0x84, 0x09 },
    { 0x00, 0x02 },
    { 0x48, 0x02 },
    { 0x74, 0x02 },
    { 0x68, 0x00 },
    { 0x01, 0x8f },
    { 0x30, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x86 },
    { 0x01, 0x84 },
    { 0xc0, 0x2b },
    { 0x00, 0x84 },
    { 0xc2, 0x4b },
    { 0x00, 0x02 },
    { 0x48, 0x06 },
    { 0xeb, 0x84 },
    { 0x4a, 0x04 },
    { 0x00, 0x84 },
    { 0xc1, 0x06 },
    { 0xeb, 0x04 },
    { 0x20, 0x18 },
    { 0x0e, 0x8f },
    { 0x48, 0x00 },
    { 0x1d, 0xe0 },
    { 0x10, 0x50 },
    { 0x77, 0x02 },
    { 0x50, 0x02 },
    { 0x78, 0x84 },
    { 0x4a, 0x04 },
    { 0x08, 0x84 },
    { 0x52, 0x04 },
    { 0x01, 0x8f },
    { 0x48, 0x00 },
    { 0x15, 0x8f },
    { 0x50, 0x00 },
    { 0x25, 0x84 },
    { 0x4a, 0x04 },
    { 0x04, 0x84 },
    { 0x52, 0x04 },
    { 0x0a, 0x8e },
    { 0xfd, 0x06 },
    { 0xeb, 0x8f },
    { 0x70, 0x00 },
    { 0x00, 0x88 },
    { 0x07, 0x00 },
    { 0x82, 0x02 },
    { 0x68, 0x00 },
    { 0x01, 0x84 },
    { 0xc8, 0x01 },
    { 0x01, 0x00 },
    { 0x00, 0x10 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x10 },
    { 0x00, 0x10 },
    { 0x0e, 0x02 },
    { 0x68, 0x00 },
    { 0x02, 0x04 },
    { 0xa0, 0x19 },
    { 0x4c, 0x84 },
    { 0xc8, 0x0b },
    { 0x03, 0x84 },
    { 0xd8, 0x01 },
    { 0x00, 0xe0 },
    { 0x10, 0x10 },
    { 0xd7, 0x88 },
    { 0x07, 0x00 },
    { 0x80, 0x10 },
    { 0x00, 0x18 },
    { 0x02, 0x86 },
    { 0xa1, 0x00 },
    { 0xd8, 0x04 },
    { 0x60, 0x59 },
    { 0x1e, 0x8c },
    { 0xff, 0x01 },
    { 0xb0, 0xe0 },
    { 0x10, 0x40 },
    { 0x00, 0x02 },
    { 0x28, 0x00 },
    { 0x36, 0x84 },
    { 0x2a, 0x04 },
    { 0x07, 0x02 },
    { 0x28, 0x00 },
    { 0x2f, 0x88 },
    { 0x07, 0x00 },
    { 0x82, 0x84 },
    { 0x2a, 0x04 },
    { 0x05, 0x0c },
    { 0x60, 0x48 },
    { 0x10, 0x02 },
    { 0x28, 0x00 },
    { 0x2d, 0x04 },
    { 0x60, 0x79 },
    { 0x0e, 0x84 },
    { 0x2a, 0x04 },
    { 0x02, 0xe0 },
    { 0x10, 0x50 },
    { 0xd9, 0x02 },
    { 0x28, 0x00 },
    { 0x35, 0x84 },
    { 0x2a, 0x04 },
    { 0x06, 0x02 },
    { 0x28, 0x00 },
    { 0x37, 0x88 },
    { 0x07, 0x00 },
    { 0x82, 0x0c },
    { 0x60, 0x68 },
    { 0x10, 0x84 },
    { 0x84, 0x09 },
    { 0x00, 0x84 },
    { 0x42, 0x04 },
    { 0x09, 0x02 },
    { 0x00, 0x00 },
    { 0x2e, 0x00 },
    { 0x00, 0x11 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x84 },
    { 0x40, 0x04 },
    { 0x0d, 0x84 },
    { 0x02, 0x04 },
    { 0x03, 0x02 },
    { 0x50, 0x01 },
    { 0xf8, 0x02 },
    { 0x48, 0x01 },
    { 0xf0, 0x84 },
    { 0x2a, 0x04 },
    { 0x0b, 0x00 },
    { 0xff, 0x22 },
    { 0xa5, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0x40, 0x04 },
    { 0x0d, 0x84 },
    { 0xc0, 0x04 },
    { 0x0f, 0x8f },
    { 0x48, 0x00 },
    { 0x1d, 0x02 },
    { 0x60, 0x00 },
    { 0x01, 0x02 },
    { 0x50, 0x02 },
    { 0x78, 0x02 },
    { 0x58, 0x00 },
    { 0x8f, 0x00 },
    { 0x00, 0x8e },
    { 0x03, 0x84 },
    { 0xd0, 0x01 },
    { 0x00, 0x84 },
    { 0xc8, 0x49 },
    { 0x00, 0x84 },
    { 0xca, 0x09 },
    { 0x00, 0x86 },
    { 0xd2, 0x69 },
    { 0x00, 0x84 },
    { 0x42, 0x04 },
    { 0x0d, 0x84 },
    { 0x58, 0x04 },
    { 0x10, 0x84 },
    { 0x50, 0x04 },
    { 0x0e, 0x8f },
    { 0x40, 0x00 },
    { 0x25, 0x00 },
    { 0x00, 0x8e },
    { 0x03, 0x84 },
    { 0xc8, 0x29 },
    { 0x00, 0x84 },
    { 0xd0, 0x09 },
    { 0x00, 0x86 },
    { 0xca, 0x49 },
    { 0x00, 0x86 },
    { 0xd2, 0x69 },
    { 0x00, 0x8c },
    { 0xff, 0x00 },
    { 0x3e, 0x02 },
    { 0xd0, 0x00 },
    { 0x01, 0x04 },
    { 0x20, 0x0c },
    { 0x4e, 0x00 },
    { 0x00, 0x12 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x08 },
    { 0x00, 0xd0 },
    { 0x20, 0x02 },
    { 0xc8, 0x00 },
    { 0x00, 0x08 },
    { 0x44, 0x26 },
    { 0x32, 0x02 },
    { 0x48, 0x00 },
    { 0x7d, 0x08 },
    { 0x00, 0x2c },
    { 0x00, 0x84 },
    { 0xd3, 0x00 },
    { 0x3e, 0x02 },
    { 0x40, 0x04 },
    { 0x00, 0x84 },
    { 0x52, 0x04 },
    { 0x0e, 0x84 },
    { 0xc2, 0x04 },
    { 0x0f, 0x06 },
    { 0x60, 0x10 },
    { 0x04, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x62, 0x21 },
    { 0x37, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x86 },
    { 0x61, 0x00 },
    { 0x7d, 0x8f },
    { 0x48, 0x00 },
    { 0x25, 0x02 },
    { 0x40, 0x06 },
    { 0xbb, 0x02 },
    { 0x50, 0x02 },
    { 0x78, 0x02 },
    { 0x68, 0x00 },
    { 0x01, 0x02 },
    { 0x58, 0x06 },
    { 0xbb, 0x00 },
    { 0x00, 0x8e },
    { 0x02, 0x84 },
    { 0xc0, 0x69 },
    { 0x00, 0x84 },
    { 0xc2, 0x0b },
    { 0x00, 0x84 },
    { 0xc2, 0x4b },
    { 0x00, 0x02 },
    { 0x40, 0x02 },
    { 0x44, 0x02 },
    { 0x50, 0x02 },
    { 0x74, 0x8f },
    { 0x58, 0x00 },
    { 0x1d, 0x00 },
    { 0x00, 0x8e },
    { 0x03, 0x10 },
    { 0x18, 0x81 },
    { 0x00, 0x10 },
    { 0x18, 0xc0 },
    { 0x00, 0x00 },
    { 0x00, 0x13 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x84 },
    { 0xd2, 0x6b },
    { 0x00, 0x84 },
    { 0xc2, 0x2b },
    { 0x00, 0x02 },
    { 0x48, 0x00 },
    { 0x17, 0x02 },
    { 0x40, 0x02 },
    { 0x78, 0x84 },
    { 0x4a, 0x04 },
    { 0x00, 0x02 },
    { 0x48, 0x00 },
    { 0x15, 0x02 },
    { 0x50, 0x00 },
    { 0x1d, 0x00 },
    { 0xff, 0x03 },
    { 0x2b, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0x48, 0x00 },
    { 0x7e, 0x84 },
    { 0x4a, 0x04 },
    { 0x00, 0x02 },
    { 0xc0, 0x00 },
    { 0x17, 0x84 },
    { 0xc2, 0x04 },
    { 0x01, 0x02 },
    { 0x40, 0x02 },
    { 0x78, 0x02 },
    { 0x48, 0x00 },
    { 0x57, 0x02 },
    { 0x50, 0x00 },
    { 0x03, 0x00 },
    { 0xff, 0x04 },
    { 0xda, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x8e },
    { 0xfd, 0x00 },
    { 0x57, 0x8f },
    { 0x70, 0x00 },
    { 0x0c, 0x8f },
    { 0x78, 0x00 },
    { 0x12, 0x02 },
    { 0x69, 0xff },
    { 0xac, 0x8c },
    { 0xff, 0x06 },
    { 0x94, 0x84 },
    { 0xc0, 0x41 },
    { 0x00, 0x84 },
    { 0xc2, 0x0b },
    { 0x00, 0x84 },
    { 0x42, 0x04 },
    { 0x0d, 0x84 },
    { 0x5a, 0x04 },
    { 0x0e, 0x02 },
    { 0x48, 0x00 },
    { 0x99, 0x02 },
    { 0x60, 0x00 },
    { 0x01, 0x02 },
    { 0x40, 0x02 },
    { 0x78, 0x00 },
    { 0x00, 0x14 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x00, 0x8e },
    { 0x03, 0x84 },
    { 0xa0, 0x01 },
    { 0x00, 0xe0 },
    { 0x0c, 0xe0 },
    { 0x00, 0x88 },
    { 0x07, 0x00 },
    { 0x64, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0x52, 0x04 },
    { 0x0f, 0x02 },
    { 0x50, 0x00 },
    { 0x17, 0x02 },
    { 0x40, 0x00 },
    { 0x2a, 0x00 },
    { 0xff, 0x02 },
    { 0x9c, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x86 },
    { 0xa1, 0x00 },
    { 0x00, 0x02 },
    { 0x48, 0x02 },
    { 0x78, 0x02 },
    { 0x60, 0x00 },
    { 0x01, 0x02 },
    { 0x50, 0x00 },
    { 0x17, 0x00 },
    { 0x00, 0x8e },
    { 0x02, 0xe0 },
    { 0x60, 0x00 },
    { 0x00, 0x88 },
    { 0x07, 0x20 },
    { 0x65, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0x40, 0x00 },
    { 0x54, 0x02 },
    { 0x48, 0x00 },
    { 0x01, 0x00 },
    { 0xff, 0x00 },
    { 0xc9, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0x40, 0x02 },
    { 0x78, 0x02 },
    { 0x48, 0x00 },
    { 0x54, 0x02 },
    { 0x50, 0x00 },
    { 0x02, 0x00 },
    { 0xff, 0x00 },
    { 0xae, 0x02 },
    { 0xc0, 0x00 },
    { 0x08, 0x02 },
    { 0xc0, 0x00 },
    { 0x7e, 0x84 },
    { 0xc2, 0x04 },
    { 0x00, 0x02 },
    { 0x40, 0x00 },
    { 0x8a, 0x00 },
    { 0x00, 0x15 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x02 },
    { 0x48, 0x00 },
    { 0x1f, 0x02 },
    { 0x50, 0x00 },
    { 0x57, 0x00 },
    { 0xff, 0x00 },
    { 0x4a, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0x28, 0x00 },
    { 0x6f, 0x8c },
    { 0xff, 0x00 },
    { 0x7e, 0x84 },
    { 0x50, 0x04 },
    { 0x0e, 0x84 },
    { 0x48, 0x04 },
    { 0x0f, 0xe0 },
    { 0x10, 0x02 },
    { 0x00, 0x02 },
    { 0x28, 0x01 },
    { 0x51, 0x02 },
    { 0x58, 0x02 },
    { 0x78, 0xf0 },
    { 0x40, 0x00 },
    { 0x00, 0x86 },
    { 0xa0, 0x01 },
    { 0x01, 0x82 },
    { 0x87, 0x50 },
    { 0x66, 0x02 },
    { 0x60, 0x00 },
    { 0x01, 0x02 },
    { 0x40, 0x02 },
    { 0x78, 0x00 },
    { 0x00, 0x8e },
    { 0x02, 0xe0 },
    { 0x20, 0x00 },
    { 0x00, 0x88 },
    { 0x07, 0x00 },
    { 0x64, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0xc1, 0x00 },
    { 0x3f, 0x08 },
    { 0xfc, 0x04 },
    { 0xd9, 0x8c },
    { 0xff, 0x00 },
    { 0x57, 0x84 },
    { 0xc0, 0x21 },
    { 0x00, 0x84 },
    { 0xd0, 0x01 },
    { 0x0e, 0x86 },
    { 0xd9, 0x00 },
    { 0x66, 0x08 },
    { 0xfc, 0x04 },
    { 0x38, 0x02 },
    { 0x6b, 0x00 },
    { 0x19, 0x08 },
    { 0xfc, 0x44 },
    { 0x3a, 0x8e },
    { 0xfd, 0x00 },
    { 0x99, 0x00 },
    { 0x00, 0x16 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x8c },
    { 0xff, 0x02 },
    { 0x80, 0x84 },
    { 0x70, 0x04 },
    { 0x0c, 0x84 },
    { 0xc8, 0x21 },
    { 0x02, 0x86 },
    { 0xc3, 0x00 },
    { 0x64, 0x86 },
    { 0xd3, 0x00 },
    { 0x65, 0x84 },
    { 0x84, 0x0b },
    { 0x00, 0x84 },
    { 0xda, 0x04 },
    { 0x0e, 0x02 },
    { 0x78, 0x00 },
    { 0x02, 0x00 },
    { 0x00, 0x8e },
    { 0x08, 0x84 },
    { 0x84, 0x0d },
    { 0x00, 0x84 },
    { 0xd2, 0x09 },
    { 0x00, 0x84 },
    { 0xc2, 0x09 },
    { 0x00, 0x84 },
    { 0xd8, 0x04 },
    { 0x0e, 0x84 },
    { 0xda, 0x09 },
    { 0x00, 0x84 },
    { 0xd8, 0x49 },
    { 0x00, 0x08 },
    { 0xfc, 0x64 },
    { 0x3b, 0x84 },
    { 0xda, 0x09 },
    { 0x00, 0x84 },
    { 0xca, 0x0f },
    { 0x00, 0x02 },
    { 0xc0, 0x00 },
    { 0x47, 0x02 },
    { 0x48, 0x03 },
    { 0x80, 0x84 },
    { 0x50, 0x04 },
    { 0x0d, 0x86 },
    { 0xa1, 0x00 },
    { 0x76, 0x00 },
    { 0x00, 0x8e },
    { 0x02, 0xe0 },
    { 0xe0, 0x00 },
    { 0x00, 0x88 },
    { 0x07, 0x20 },
    { 0x67, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0xc2, 0x04 },
    { 0x00, 0x8c },
    { 0xff, 0x02 },
    { 0x78, 0x00 },
    { 0xff, 0x02 },
    { 0x04, 0x84 },
    { 0x84, 0x2b },
    { 0x00, 0x00 },
    { 0x00, 0x17 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x84 },
    { 0xc1, 0x00 },
    { 0x3f, 0x08 },
    { 0xfc, 0x04 },
    { 0x7a, 0x84 },
    { 0x48, 0x04 },
    { 0x0d, 0x8c },
    { 0xff, 0x01 },
    { 0xe0, 0x02 },
    { 0x6b, 0x00 },
    { 0x1a, 0x8f },
    { 0x68, 0x00 },
    { 0x55, 0x84 },
    { 0x84, 0x0b },
    { 0x00, 0x02 },
    { 0x60, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x8e },
    { 0x01, 0x84 },
    { 0xd0, 0x29 },
    { 0x00, 0x84 },
    { 0xd2, 0x09 },
    { 0x00, 0x85 },
    { 0x49, 0x00 },
    { 0x17, 0x02 },
    { 0xd0, 0x00 },
    { 0x01, 0x02 },
    { 0x48, 0x00 },
    { 0x3f, 0x00 },
    { 0xfd, 0x70 },
    { 0x0e, 0x00 },
    { 0xfe, 0x20 },
    { 0x7c, 0x0c },
    { 0x60, 0x1c },
    { 0x10, 0x8f },
    { 0x00, 0xff },
    { 0xb2, 0x84 },
    { 0x42, 0x04 },
    { 0x0b, 0x86 },
    { 0xa1, 0x01 },
    { 0x83, 0x8f },
    { 0x58, 0x00 },
    { 0x46, 0x02 },
    { 0x68, 0x00 },
    { 0x01, 0x8f },
    { 0xa0, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x8e },
    { 0x01, 0xe4 },
    { 0x0d, 0xa0 },
    { 0x00, 0x80 },
    { 0x47, 0x60 },
    { 0x6f, 0x8f },
    { 0x28, 0x00 },
    { 0x00, 0x8f },
    { 0x58, 0x00 },
    { 0x11, 0x8f },
    { 0x40, 0x00 },
    { 0x12, 0x84 },
    { 0x5a, 0x04 },
    { 0x03, 0x00 },
    { 0x00, 0x18 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x84 },
    { 0x42, 0x04 },
    { 0x04, 0x8f },
    { 0x58, 0x00 },
    { 0x13, 0x8f },
    { 0x40, 0x00 },
    { 0x10, 0x84 },
    { 0x5a, 0x04 },
    { 0x05, 0x84 },
    { 0x42, 0x04 },
    { 0x02, 0x02 },
    { 0x40, 0x07 },
    { 0xdc, 0x8f },
    { 0x58, 0x00 },
    { 0x14, 0x84 },
    { 0x42, 0x04 },
    { 0x00, 0x84 },
    { 0x5a, 0x04 },
    { 0x06, 0x8f },
    { 0x20, 0xff },
    { 0xc5, 0x8f },
    { 0x58, 0x00 },
    { 0x0f, 0x02 },
    { 0xc0, 0x01 },
    { 0x91, 0x84 },
    { 0x02, 0x04 },
    { 0x0d, 0x84 },
    { 0x42, 0x04 },
    { 0x07, 0x84 },
    { 0x42, 0x04 },
    { 0x0c, 0x84 },
    { 0x4a, 0x04 },
    { 0x0e, 0x84 },
    { 0x5a, 0x04 },
    { 0x01, 0x84 },
    { 0xc2, 0x04 },
    { 0x08, 0x00 },
    { 0xff, 0x12 },
    { 0xb1, 0x8c },
    { 0xfe, 0x04 },
    { 0x46, 0x8f },
    { 0x40, 0x00 },
    { 0x15, 0x84 },
    { 0x42, 0x04 },
    { 0x01, 0x8f },
    { 0x48, 0x00 },
    { 0x13, 0x8f },
    { 0x40, 0x00 },
    { 0x16, 0x84 },
    { 0x42, 0x04 },
    { 0x02, 0x84 },
    { 0x4a, 0x04 },
    { 0x00, 0x8f },
    { 0x40, 0x00 },
    { 0x18, 0x84 },
    { 0x48, 0x04 },
    { 0x0c, 0x84 },
    { 0x42, 0x04 },
    { 0x04, 0x8f },
    { 0x50, 0x00 },
    { 0x17, 0x00 },
    { 0x00, 0x19 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x8f },
    { 0x60, 0xff },
    { 0x4e, 0x8f },
    { 0x48, 0x00 },
    { 0x19, 0x84 },
    { 0x4a, 0x04 },
    { 0x05, 0x84 },
    { 0x52, 0x04 },
    { 0x03, 0x8f },
    { 0x48, 0x00 },
    { 0x1b, 0x84 },
    { 0x4a, 0x04 },
    { 0x07, 0x8f },
    { 0x50, 0x00 },
    { 0x1c, 0x84 },
    { 0x52, 0x04 },
    { 0x08, 0x84 },
    { 0x42, 0x04 },
    { 0x09, 0x84 },
    { 0x42, 0x04 },
    { 0x0c, 0x8f },
    { 0x48, 0x00 },
    { 0x1a, 0x02 },
    { 0xc0, 0x01 },
    { 0xb3, 0x84 },
    { 0x4a, 0x04 },
    { 0x06, 0x84 },
    { 0x40, 0x04 },
    { 0x0e, 0x8f },
    { 0x50, 0x00 },
    { 0x14, 0x84 },
    { 0xc2, 0x04 },
    { 0x0a, 0x00 },
    { 0xff, 0x10 },
    { 0xcb, 0x8e },
    { 0xfc, 0x04 },
    { 0x46, 0x84 },
    { 0x48, 0x04 },
    { 0x0c, 0x8f },
    { 0x40, 0x00 },
    { 0x14, 0x84 },
    { 0x42, 0x04 },
    { 0x00, 0x8f },
    { 0x68, 0x00 },
    { 0xb0, 0x8f },
    { 0x50, 0x00 },
    { 0x18, 0x84 },
    { 0x4a, 0x04 },
    { 0x06, 0x84 },
    { 0x52, 0x04 },
    { 0x01, 0x84 },
    { 0x4a, 0x04 },
    { 0x0c, 0x8f },
    { 0x40, 0x00 },
    { 0x1d, 0x84 },
    { 0x42, 0x04 },
    { 0x02, 0x8f },
    { 0x48, 0x00 },
    { 0x22, 0x8f },
    { 0x50, 0x00 },
    { 0x24, 0x00 },
    { 0x00, 0x1a },
    { CFG_META_BURST, 120 },
    { 0x08, 0x84 },
    { 0x4a, 0x04 },
    { 0x03, 0x84 },
    { 0x52, 0x04 },
    { 0x05, 0x8f },
    { 0x40, 0x00 },
    { 0x23, 0x02 },
    { 0xc0, 0x01 },
    { 0x85, 0x8e },
    { 0xfc, 0x04 },
    { 0x16, 0x8f },
    { 0x50, 0x00 },
    { 0x17, 0x84 },
    { 0x42, 0x04 },
    { 0x04, 0x84 },
    { 0xc2, 0x04 },
    { 0x07, 0x00 },
    { 0xff, 0x10 },
    { 0x4a, 0x8c },
    { 0xfe, 0x04 },
    { 0x15, 0x84 },
    { 0x48, 0x04 },
    { 0x0c, 0x84 },
    { 0x58, 0x04 },
    { 0x0b, 0x84 },
    { 0xc0, 0x04 },
    { 0x4e, 0x8f },
    { 0x70, 0x00 },
    { 0x3e, 0x84 },
    { 0x52, 0x04 },
    { 0x0e, 0x84 },
    { 0x48, 0x41 },
    { 0x00, 0x8f },
    { 0x40, 0x00 },
    { 0x46, 0x02 },
    { 0x68, 0x00 },
    { 0x01, 0x02 },
    { 0x70, 0x00 },
    { 0x7f, 0x8f },
    { 0x50, 0x00 },
    { 0x13, 0x00 },
    { 0x00, 0x8e },
    { 0x03, 0x84 },
    { 0xc8, 0x6b },
    { 0x00, 0x84 },
    { 0xca, 0x20 },
    { 0xf0, 0x84 },
    { 0xc8, 0x21 },
    { 0x00, 0x84 },
    { 0xca, 0x0b },
    { 0x00, 0x8f },
    { 0x40, 0x00 },
    { 0x1a, 0x84 },
    { 0x58, 0x04 },
    { 0x0c, 0x84 },
    { 0x42, 0x04 },
    { 0x02, 0x84 },
    { 0x52, 0x04 },
    { 0x01, 0x8f },
    { 0x40, 0x00 },
    { 0x25, 0x00 },
    { 0x00, 0x1b },
    { CFG_META_BURST, 120 },
    { 0x08, 0x84 },
    { 0x42, 0x04 },
    { 0x05, 0x84 },
    { 0x4a, 0x61 },
    { 0x3e, 0x8f },
    { 0x50, 0x00 },
    { 0x12, 0x8f },
    { 0x48, 0x00 },
    { 0x46, 0x84 },
    { 0x4a, 0x04 },
    { 0x04, 0x8f },
    { 0x40, 0x00 },
    { 0x2d, 0x84 },
    { 0x52, 0x04 },
    { 0x03, 0x84 },
    { 0x48, 0x04 },
    { 0x0e, 0x84 },
    { 0x42, 0x04 },
    { 0x06, 0x8f },
    { 0x50, 0x00 },
    { 0x31, 0x8f },
    { 0x40, 0x00 },
    { 0x36, 0x84 },
    { 0x52, 0x04 },
    { 0x07, 0x8f },
    { 0x68, 0xff },
    { 0x32, 0x84 },
    { 0x42, 0x04 },
    { 0x08, 0x02 },
    { 0xc8, 0x00 },
    { 0xfa, 0x84 },
    { 0x4a, 0x04 },
    { 0x09, 0x84 },
    { 0xc2, 0x04 },
    { 0x00, 0x84 },
    { 0x40, 0x04 },
    { 0x0b, 0x84 },
    { 0x4a, 0x04 },
    { 0x0c, 0x8f },
    { 0x50, 0x00 },
    { 0x1d, 0x84 },
    { 0xca, 0x04 },
    { 0x0a, 0x00 },
    { 0xff, 0x09 },
    { 0xe9, 0x8e },
    { 0xfc, 0x04 },
    { 0x10, 0x84 },
    { 0x50, 0x04 },
    { 0x4f, 0x84 },
    { 0x40, 0x04 },
    { 0x50, 0x84 },
    { 0x48, 0x04 },
    { 0x51, 0x8f },
    { 0x58, 0x00 },
    { 0x25, 0x02 },
    { 0x68, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x8e },
    { 0x01, 0x84 },
    { 0xc0, 0x6b },
    { 0x00, 0x00 },
    { 0x00, 0x1c },
    { CFG_META_BURST, 120 },
    { 0x08, 0x84 },
    { 0xc2, 0x4b },
    { 0x00, 0x84 },
    { 0xc0, 0x04 },
    { 0x10, 0x84 },
    { 0x50, 0x04 },
    { 0x0c, 0x84 },
    { 0xc2, 0x01 },
    { 0x00, 0x84 },
    { 0xc0, 0x04 },
    { 0x14, 0x8f },
    { 0xa0, 0x00 },
    { 0xcd, 0x84 },
    { 0xc2, 0x21 },
    { 0x00, 0x84 },
    { 0x42, 0x04 },
    { 0x0b, 0x84 },
    { 0xc0, 0x01 },
    { 0x00, 0x8f },
    { 0x50, 0x00 },
    { 0x46, 0x84 },
    { 0x48, 0x04 },
    { 0x52, 0x8f },
    { 0xa0, 0x00 },
    { 0x00, 0x02 },
    { 0x60, 0x00 },
    { 0x02, 0x00 },
    { 0x00, 0x8e },
    { 0x00, 0x84 },
    { 0xc2, 0x0b },
    { 0x00, 0x84 },
    { 0x40, 0x04 },
    { 0x54, 0x84 },
    { 0x58, 0x04 },
    { 0x53, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x8e },
    { 0x01, 0x84 },
    { 0xc0, 0x4b },
    { 0x00, 0x84 },
    { 0xc2, 0x2b },
    { 0x00, 0x84 },
    { 0xc0, 0x04 },
    { 0x15, 0x84 },
    { 0x48, 0x04 },
    { 0x55, 0x84 },
    { 0xc2, 0x61 },
    { 0x00, 0x84 },
    { 0xc8, 0x04 },
    { 0x16, 0x84 },
    { 0xca, 0x01 },
    { 0x00, 0x84 },
    { 0xc0, 0x04 },
    { 0x17, 0x84 },
    { 0xc2, 0x21 },
    { 0x00, 0x8f },
    { 0x48, 0x00 },
    { 0x46, 0x86 },
    { 0xa1, 0x01 },
    { 0x84, 0x00 },
    { 0x00, 0x1d },
    { CFG_META_BURST, 120 },
    { 0x08, 0x8f },
    { 0x40, 0x00 },
    { 0x25, 0x8f },
    { 0x70, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x8e },
    { 0x01, 0xe4 },
    { 0x0d, 0x80 },
    { 0x00, 0x80 },
    { 0x40, 0x40 },
    { 0x6e, 0x84 },
    { 0x40, 0x04 },
    { 0x0b, 0x84 },
    { 0x00, 0x04 },
    { 0x0d, 0x8f },
    { 0x50, 0x00 },
    { 0x3e, 0x84 },
    { 0x40, 0x01 },
    { 0x02, 0x8f },
    { 0x58, 0x00 },
    { 0x31, 0x02 },
    { 0x70, 0x00 },
    { 0x04, 0x02 },
    { 0x78, 0x00 },
    { 0x03, 0x00 },
    { 0x00, 0x8e },
    { 0x08, 0x84 },
    { 0xa0, 0x04 },
    { 0x31, 0xe0 },
    { 0x0d, 0xa0 },
    { 0x00, 0x86 },
    { 0x82, 0x00 },
    { 0xe8, 0x70 },
    { 0xe0, 0x20 },
    { 0xe8, 0xf8 },
    { 0xe0, 0x40 },
    { 0xe8, 0x70 },
    { 0xe0, 0x60 },
    { 0xe8, 0xf8 },
    { 0xe0, 0x80 },
    { 0xf8, 0x82 },
    { 0x07, 0x00 },
    { 0xe0, 0x80 },
    { 0x07, 0x00 },
    { 0x6e, 0x84 },
    { 0x48, 0x04 },
    { 0x0b, 0x84 },
    { 0xc0, 0x04 },
    { 0x11, 0x8f },
    { 0x50, 0x00 },
    { 0x3e, 0x84 },
    { 0x42, 0x21 },
    { 0x02, 0x84 },
    { 0x48, 0x04 },
    { 0x56, 0x8f },
    { 0x40, 0x00 },
    { 0x36, 0x02 },
    { 0xc8, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x8e },
    { 0x08, 0x00 },
    { 0x00, 0x1e },
    { CFG_META_BURST, 120 },
    { 0x08, 0x08 },
    { 0x00, 0x10 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x66, 0x23 },
    { 0x6c, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0xca, 0x41 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0xd0, 0x4b },
    { 0x00, 0x84 },
    { 0xd2, 0x2b },
    { 0x00, 0x84 },
    { 0x48, 0x04 },
    { 0x57, 0x8f },
    { 0x50, 0x00 },
    { 0x2d, 0x00 },
    { 0x00, 0x86 },
    { 0x01, 0x84 },
    { 0xc8, 0x4b },
    { 0x00, 0x84 },
    { 0xca, 0x2b },
    { 0x00, 0x84 },
    { 0x48, 0x04 },
    { 0x58, 0x84 },
    { 0x50, 0x04 },
    { 0x59, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x8e },
    { 0x01, 0x84 },
    { 0xc8, 0x0b },
    { 0x00, 0x84 },
    { 0xca, 0x2b },
    { 0x00, 0x84 },
    { 0xc2, 0x41 },
    { 0x00, 0x84 },
    { 0xc0, 0x04 },
    { 0x12, 0x84 },
    { 0xc2, 0x41 },
    { 0x01, 0x84 },
    { 0xc0, 0x04 },
    { 0x13, 0x84 },
    { 0xc2, 0x41 },
    { 0x02, 0x84 },
    { 0xc8, 0x04 },
    { 0x1b, 0x84 },
    { 0xc0, 0x04 },
    { 0x19, 0x84 },
    { 0xca, 0x41 },
    { 0x03, 0x84 },
    { 0xc2, 0x41 },
    { 0x04, 0x84 },
    { 0x0c, 0x04 },
    { 0x1a, 0x00 },
    { 0x00, 0x1f },
    { CFG_META_BURST, 120 },
    { 0x08, 0x84 },
    { 0xc0, 0x04 },
    { 0x1c, 0x84 },
    { 0x0e, 0x41 },
    { 0x05, 0x84 },
    { 0xc2, 0x41 },
    { 0x06, 0x00 },
    { 0xfc, 0x50 },
    { 0x00, 0x8f },
    { 0x00, 0x00 },
    { 0x4e, 0x8f },
    { 0x00, 0xff },
    { 0xef, 0x84 },
    { 0x02, 0x04 },
    { 0x0f, 0x02 },
    { 0x40, 0x06 },
    { 0xef, 0x02 },
    { 0xc8, 0x00 },
    { 0xf0, 0x00 },
    { 0xff, 0x19 },
    { 0x55, 0x02 },
    { 0xc0, 0x00 },
    { 0x00, 0x02 },
    { 0x40, 0x06 },
    { 0xef, 0x00 },
    { 0xff, 0x03 },
    { 0x81, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x8e },
    { 0xfd, 0x06 },
    { 0xef, 0x8c },
    { 0xfe, 0x21 },
    { 0x20, 0x84 },
    { 0x42, 0x04 },
    { 0x10, 0x00 },
    { 0xff, 0x03 },
    { 0x6e, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0x40, 0x04 },
    { 0x10, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x8f },
    { 0x20, 0x00 },
    { 0x90, 0x84 },
    { 0x42, 0x04 },
    { 0x10, 0x00 },
    { 0xff, 0x03 },
    { 0x71, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0x40, 0x04 },
    { 0x10, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x8c },
    { 0xfe, 0x01 },
    { 0x02, 0x00 },
    { 0x00, 0x20 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x84 },
    { 0x42, 0x04 },
    { 0x10, 0x00 },
    { 0xff, 0x03 },
    { 0x8d, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0xc0, 0x01 },
    { 0x91, 0x84 },
    { 0x40, 0x04 },
    { 0x10, 0x84 },
    { 0xc2, 0x04 },
    { 0x00, 0x02 },
    { 0x48, 0x00 },
    { 0x28, 0x02 },
    { 0x50, 0x00 },
    { 0x30, 0x00 },
    { 0xff, 0x03 },
    { 0x84, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0xc0, 0x00 },
    { 0x48, 0x02 },
    { 0xc8, 0x01 },
    { 0xb3, 0x02 },
    { 0x48, 0x00 },
    { 0x20, 0x02 },
    { 0x50, 0x00 },
    { 0x40, 0x84 },
    { 0x40, 0x04 },
    { 0x10, 0x84 },
    { 0xc2, 0x04 },
    { 0x00, 0x84 },
    { 0xca, 0x04 },
    { 0x01, 0x8f },
    { 0x20, 0xff },
    { 0x4e, 0x84 },
    { 0x42, 0x04 },
    { 0x10, 0x00 },
    { 0xff, 0x03 },
    { 0x74, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0xc0, 0x00 },
    { 0xd0, 0x84 },
    { 0xc2, 0x04 },
    { 0x01, 0x02 },
    { 0xc0, 0x00 },
    { 0xc0, 0x84 },
    { 0xc2, 0x04 },
    { 0x00, 0x02 },
    { 0xc0, 0x00 },
    { 0xd8, 0x84 },
    { 0x40, 0x04 },
    { 0x10, 0x84 },
    { 0xc2, 0x04 },
    { 0x05, 0x02 },
    { 0xc8, 0x00 },
    { 0xc8, 0x02 },
    { 0x61, 0xff },
    { 0x32, 0x00 },
    { 0x00, 0x21 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x84 },
    { 0xca, 0x04 },
    { 0x04, 0x8f },
    { 0x20, 0x00 },
    { 0xee, 0x02 },
    { 0xc0, 0x01 },
    { 0x00, 0x84 },
    { 0xc2, 0x09 },
    { 0x00, 0x02 },
    { 0xc8, 0x00 },
    { 0xa0, 0x02 },
    { 0xd0, 0x00 },
    { 0x70, 0x84 },
    { 0xca, 0x04 },
    { 0x02, 0x84 },
    { 0xd2, 0x04 },
    { 0x06, 0x02 },
    { 0x28, 0x00 },
    { 0xb8, 0x02 },
    { 0xc8, 0x00 },
    { 0x80, 0x02 },
    { 0xc0, 0x00 },
    { 0x78, 0x02 },
    { 0xd0, 0x00 },
    { 0x06, 0x84 },
    { 0x2a, 0x04 },
    { 0x03, 0x84 },
    { 0xca, 0x04 },
    { 0x07, 0x84 },
    { 0xc2, 0x04 },
    { 0x08, 0x84 },
    { 0xd2, 0x04 },
    { 0x09, 0x02 },
    { 0x28, 0x00 },
    { 0x08, 0x02 },
    { 0xd0, 0x00 },
    { 0x10, 0x02 },
    { 0xc0, 0x00 },
    { 0x00, 0x02 },
    { 0xc8, 0x00 },
    { 0x18, 0x02 },
    { 0xd8, 0x00 },
    { 0xfa, 0x84 },
    { 0x42, 0x04 },
    { 0x10, 0x02 },
    { 0x48, 0x00 },
    { 0x90, 0x02 },
    { 0x50, 0x00 },
    { 0xb0, 0x84 },
    { 0x2a, 0x04 },
    { 0x0a, 0x84 },
    { 0xd2, 0x04 },
    { 0x0b, 0x84 },
    { 0xc2, 0x04 },
    { 0x0c, 0x84 },
    { 0xca, 0x04 },
    { 0x0d, 0x84 },
    { 0xda, 0x04 },
    { 0x0e, 0x00 },
    { 0xff, 0x09 },
    { 0xbe, 0x00 },
    { 0x00, 0x22 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0x40, 0x04 },
    { 0x10, 0x84 },
    { 0x00, 0x04 },
    { 0x0f, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x8f },
    { 0x20, 0x00 },
    { 0xcf, 0x02 },
    { 0xc0, 0x00 },
    { 0x68, 0x84 },
    { 0xc2, 0x01 },
    { 0x00, 0x00 },
    { 0xfc, 0x50 },
    { 0x00, 0x8f },
    { 0x00, 0x00 },
    { 0x11, 0x8f },
    { 0x00, 0xff },
    { 0xf5, 0x02 },
    { 0xc0, 0x01 },
    { 0xd8, 0x84 },
    { 0x02, 0x04 },
    { 0x02, 0x84 },
    { 0x4a, 0x04 },
    { 0x01, 0x02 },
    { 0x50, 0x07 },
    { 0xdf, 0x84 },
    { 0xc2, 0x04 },
    { 0x00, 0x00 },
    { 0xff, 0x15 },
    { 0x20, 0x8e },
    { 0xfc, 0x04 },
    { 0x03, 0x84 },
    { 0x40, 0x04 },
    { 0x01, 0x84 },
    { 0x00, 0x04 },
    { 0x02, 0x8f },
    { 0x48, 0x00 },
    { 0x03, 0x02 },
    { 0x60, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x8e },
    { 0x01, 0x84 },
    { 0xc0, 0x29 },
    { 0x00, 0x84 },
    { 0xc2, 0x09 },
    { 0x00, 0x00 },
    { 0xfc, 0x50 },
    { 0x00, 0x8f },
    { 0x00, 0x00 },
    { 0x0b, 0x8f },
    { 0x00, 0xff },
    { 0xfa, 0x84 },
    { 0x02, 0x04 },
    { 0x05, 0x02 },
    { 0x40, 0x07 },
    { 0xdf, 0x02 },
    { 0xc8, 0x00 },
    { 0x15, 0x00 },
    { 0x00, 0x23 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0xff, 0x19 },
    { 0x55, 0x02 },
    { 0xc0, 0x00 },
    { 0x00, 0x02 },
    { 0x40, 0x07 },
    { 0xdf, 0x00 },
    { 0xff, 0x03 },
    { 0x90, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0x28, 0x01 },
    { 0x88, 0x02 },
    { 0xd0, 0x00 },
    { 0xf0, 0x02 },
    { 0xc8, 0x01 },
    { 0x80, 0x02 },
    { 0xc0, 0x00 },
    { 0xe0, 0x02 },
    { 0xd8, 0x03 },
    { 0x00, 0x02 },
    { 0x40, 0x07 },
    { 0xdf, 0x02 },
    { 0x48, 0x00 },
    { 0xe8, 0x02 },
    { 0x50, 0x00 },
    { 0xf8, 0x84 },
    { 0xd2, 0x04 },
    { 0x00, 0x84 },
    { 0xca, 0x04 },
    { 0x01, 0x84 },
    { 0xc2, 0x04 },
    { 0x02, 0x84 },
    { 0xda, 0x04 },
    { 0x03, 0x84 },
    { 0x2a, 0x04 },
    { 0x04, 0x00 },
    { 0xff, 0x15 },
    { 0x12, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0x00, 0x04 },
    { 0x05, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x50 },
    { 0x00, 0x8f },
    { 0x00, 0x00 },
    { 0x06, 0x86 },
    { 0xc1, 0x00 },
    { 0x6d, 0x08 },
    { 0x00, 0x10 },
    { 0x00, 0x8f },
    { 0x00, 0xff },
    { 0xf9, 0x8f },
    { 0x30, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x24 },
    { 0x22, 0x00 },
    { 0x00, 0x24 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x84 },
    { 0x02, 0x04 },
    { 0x00, 0x8c },
    { 0xff, 0x00 },
    { 0x6e, 0x02 },
    { 0xc0, 0x00 },
    { 0x00, 0x06 },
    { 0x20, 0x11 },
    { 0x04, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x22, 0x24 },
    { 0x29, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0x60, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x8e },
    { 0x02, 0x84 },
    { 0xc0, 0x49 },
    { 0x00, 0x84 },
    { 0xc2, 0x29 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfe, 0x24 },
    { 0x53, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0xc0, 0x00 },
    { 0x00, 0x84 },
    { 0xc2, 0x04 },
    { 0x01, 0x02 },
    { 0x60, 0x00 },
    { 0x01, 0x84 },
    { 0x4a, 0x04 },
    { 0x03, 0x84 },
    { 0xc0, 0x49 },
    { 0x00, 0x84 },
    { 0x52, 0x04 },
    { 0x02, 0x02 },
    { 0x40, 0x00 },
    { 0x5a, 0x02 },
    { 0x48, 0x00 },
    { 0x05, 0x00 },
    { 0xff, 0x14 },
    { 0x90, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0xc2, 0x04 },
    { 0x04, 0x02 },
    { 0x40, 0x00 },
    { 0x5f, 0x02 },
    { 0x48, 0x00 },
    { 0x0d, 0x00 },
    { 0xff, 0x14 },
    { 0x90, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x25 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x84 },
    { 0xc2, 0x04 },
    { 0x06, 0x86 },
    { 0xc1, 0x00 },
    { 0x6f, 0x86 },
    { 0xc9, 0x00 },
    { 0x75, 0x8e },
    { 0xfc, 0x04 },
    { 0x05, 0x00 },
    { 0xff, 0x20 },
    { 0x1b, 0x8c },
    { 0xfe, 0x04 },
    { 0x06, 0x02 },
    { 0x48, 0x00 },
    { 0x0e, 0x02 },
    { 0x40, 0x00 },
    { 0x85, 0x84 },
    { 0xc0, 0x04 },
    { 0x05, 0x00 },
    { 0xff, 0x14 },
    { 0x90, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0x40, 0x00 },
    { 0x8a, 0x02 },
    { 0x48, 0x00 },
    { 0x0f, 0x00 },
    { 0xff, 0x14 },
    { 0x90, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0xe0 },
    { 0x10, 0x10 },
    { 0x6e, 0x84 },
    { 0xc8, 0x04 },
    { 0x01, 0x08 },
    { 0x00, 0x2c },
    { 0x20, 0x08 },
    { 0x01, 0x10 },
    { 0x00, 0x02 },
    { 0xa2, 0x10 },
    { 0x00, 0x84 },
    { 0x48, 0x04 },
    { 0x03, 0x50 },
    { 0x80, 0x80 },
    { 0x00, 0x84 },
    { 0x50, 0x04 },
    { 0x02, 0x84 },
    { 0xc2, 0x04 },
    { 0x01, 0x02 },
    { 0x60, 0x00 },
    { 0x01, 0x00 },
    { 0x62, 0x24 },
    { 0x2c, 0x80 },
    { 0x07, 0x80 },
    { 0x65, 0x84 },
    { 0x00, 0x04 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x26 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0xfc, 0x50 },
    { 0x00, 0x8f },
    { 0x00, 0x00 },
    { 0x07, 0x08 },
    { 0x00, 0x10 },
    { 0x00, 0x8f },
    { 0x00, 0xff },
    { 0xfd, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x24 },
    { 0x62, 0x84 },
    { 0xc2, 0x04 },
    { 0x00, 0x02 },
    { 0x28, 0x00 },
    { 0xbd, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0x80, 0x02 },
    { 0x00, 0x84 },
    { 0x82, 0x00 },
    { 0x49, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0x60, 0x00 },
    { 0x01, 0x02 },
    { 0xc8, 0x00 },
    { 0x00, 0x02 },
    { 0x40, 0x02 },
    { 0xa7, 0x86 },
    { 0xd1, 0x02 },
    { 0xa6, 0x00 },
    { 0xfe, 0x24 },
    { 0x8a, 0x02 },
    { 0x68, 0x00 },
    { 0x02, 0x02 },
    { 0xd1, 0xff },
    { 0xff, 0x06 },
    { 0x20, 0x2c },
    { 0x5e, 0x00 },
    { 0xfd, 0x04 },
    { 0x1a, 0x86 },
    { 0x48, 0x0b },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x08 },
    { 0x00, 0x10 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x22, 0x24 },
    { 0x84, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0xd3, 0x00 },
    { 0x09, 0x08 },
    { 0x0b, 0x14 },
    { 0x40, 0x00 },
    { 0x00, 0x27 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x24 },
    { 0x86, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0xd3, 0x00 },
    { 0x09, 0x08 },
    { 0x0b, 0x34 },
    { 0x40, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x24 },
    { 0x86, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0xd3, 0x00 },
    { 0x09, 0x08 },
    { 0x0c, 0x14 },
    { 0x40, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x24 },
    { 0x86, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x86 },
    { 0xd0, 0x01 },
    { 0x00, 0x84 },
    { 0xd2, 0x21 },
    { 0x00, 0x8f },
    { 0x20, 0x00 },
    { 0x01, 0x8f },
    { 0x68, 0x00 },
    { 0x01, 0x08 },
    { 0x00, 0x2c },
    { 0x21, 0x86 },
    { 0xd1, 0x02 },
    { 0xa6, 0x0d },
    { 0x00, 0x10 },
    { 0x30, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x62, 0x24 },
    { 0x68, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0xc8, 0x00 },
    { 0x00, 0x02 },
    { 0xc0, 0x00 },
    { 0x00, 0x10 },
    { 0x18, 0x81 },
    { 0x00, 0x00 },
    { 0x00, 0x28 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0xfe, 0x24 },
    { 0x9d, 0x84 },
    { 0xd2, 0x04 },
    { 0x01, 0x02 },
    { 0xd1, 0xff },
    { 0xff, 0x06 },
    { 0x20, 0x2c },
    { 0x5e, 0x86 },
    { 0x48, 0x0b },
    { 0x00, 0x00 },
    { 0xfd, 0x04 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0xc2, 0x29 },
    { 0x00, 0x08 },
    { 0x00, 0x2c },
    { 0x21, 0x84 },
    { 0xd0, 0x04 },
    { 0x01, 0x0d },
    { 0x00, 0x10 },
    { 0x30, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x62, 0x24 },
    { 0x94, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0xc8, 0x04 },
    { 0x00, 0x08 },
    { 0x00, 0x10 },
    { 0x20, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x22, 0x24 },
    { 0xf3, 0x10 },
    { 0x18, 0x80 },
    { 0x80, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0x28, 0x00 },
    { 0xa6, 0x02 },
    { 0xd0, 0x00 },
    { 0x01, 0x84 },
    { 0x80, 0x02 },
    { 0x00, 0x84 },
    { 0x82, 0x00 },
    { 0x49, 0x00 },
    { 0xfc, 0x00 },
    { 0x03, 0x00 },
    { 0x92, 0x24 },
    { 0xb1, 0x08 },
    { 0xfc, 0x43 },
    { 0xfb, 0x00 },
    { 0x00, 0x29 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x02 },
    { 0xc0, 0x00 },
    { 0x01, 0x08 },
    { 0x00, 0x10 },
    { 0x00, 0x08 },
    { 0x20, 0x66 },
    { 0x72, 0x84 },
    { 0xd3, 0x00 },
    { 0x47, 0x84 },
    { 0xca, 0x04 },
    { 0x01, 0x02 },
    { 0xc0, 0x00 },
    { 0x7f, 0x00 },
    { 0xfe, 0x24 },
    { 0xe3, 0x02 },
    { 0xd0, 0x00 },
    { 0x00, 0x86 },
    { 0x48, 0x09 },
    { 0x00, 0x06 },
    { 0x0c, 0x8c },
    { 0x2f, 0x84 },
    { 0xd2, 0x04 },
    { 0x02, 0x02 },
    { 0xc8, 0x00 },
    { 0x01, 0x00 },
    { 0xa6, 0x24 },
    { 0xc0, 0x02 },
    { 0xd3, 0x00 },
    { 0x09, 0x00 },
    { 0xfe, 0x24 },
    { 0xc5, 0x02 },
    { 0xc8, 0x00 },
    { 0x7e, 0x0d },
    { 0x00, 0x14 },
    { 0x48, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x24 },
    { 0xda, 0x02 },
    { 0xc8, 0x00 },
    { 0x7e, 0x00 },
    { 0xfd, 0x06 },
    { 0x0f, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0xd3, 0x00 },
    { 0x09, 0x0d },
    { 0x00, 0x14 },
    { 0x48, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x24 },
    { 0xd4, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x2a },
    { CFG_META_BURST, 120 },
    { 0x08, 0x02 },
    { 0xd3, 0x00 },
    { 0x09, 0x0d },
    { 0x00, 0x14 },
    { 0x40, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x22, 0x24 },
    { 0xd6, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x86 },
    { 0xd0, 0x01 },
    { 0x00, 0x86 },
    { 0xd2, 0x21 },
    { 0x00, 0x8f },
    { 0x20, 0x00 },
    { 0x01, 0x8f },
    { 0x68, 0x00 },
    { 0x01, 0x00 },
    { 0xfe, 0x24 },
    { 0xe0, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfd, 0x06 },
    { 0x02, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x10 },
    { 0x18, 0x80 },
    { 0x80, 0x86 },
    { 0xca, 0x29 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0xc8, 0x04 },
    { 0x02, 0x08 },
    { 0x00, 0x2c },
    { 0x22, 0x84 },
    { 0xc8, 0x04 },
    { 0x01, 0x0d },
    { 0x00, 0x10 },
    { 0x48, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x62, 0x24 },
    { 0xb8, 0x02 },
    { 0xc9, 0xff },
    { 0xff, 0x00 },
    { 0xfe, 0x24 },
    { 0xf8, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0xd1, 0xff },
    { 0xff, 0x06 },
    { 0x20, 0x2c },
    { 0x57, 0x00 },
    { 0x00, 0x2b },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0xfd, 0x06 },
    { 0x02, 0x86 },
    { 0x48, 0x0b },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x10 },
    { 0x18, 0x81 },
    { 0x00, 0x86 },
    { 0xd2, 0x29 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x08 },
    { 0x00, 0x2c },
    { 0x00, 0x0d },
    { 0x00, 0x10 },
    { 0x08, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x62, 0x24 },
    { 0xea, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x02 },
    { 0xc8, 0x00 },
    { 0x00, 0x02 },
    { 0xc0, 0x00 },
    { 0x00, 0x10 },
    { 0x18, 0x81 },
    { 0x00, 0x00 },
    { 0xfe, 0x25 },
    { 0x06, 0x84 },
    { 0xd2, 0x04 },
    { 0x01, 0x02 },
    { 0xd1, 0xff },
    { 0xff, 0x06 },
    { 0x20, 0x2c },
    { 0x5e, 0x86 },
    { 0x48, 0x0b },
    { 0x00, 0x00 },
    { 0xfd, 0x04 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x86 },
    { 0xc2, 0x29 },
    { 0x00, 0x08 },
    { 0x00, 0x2c },
    { 0x21, 0x84 },
    { 0xd0, 0x04 },
    { 0x01, 0x0d },
    { 0x00, 0x10 },
    { 0x30, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x62, 0x24 },
    { 0xfd, 0x00 },
    { 0x00, 0x2c },
    { CFG_META_BURST, 48 },
    { 0x08, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x85 },
    { 0x49, 0x00 },
    { 0x17, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x84 },
    { 0xc0, 0x04 },
    { 0x00, 0x08 },
    { 0x00, 0x10 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0x26, 0x25 },
    { 0x14, 0x00 },
    { 0xfc, 0x00 },
    { 0x00, 0x00 },
    { 0xfc, 0x40 },
    { 0x00, 0x00 },
    { 0xfc, 0x50 },
    { 0x00, 0x8f },
    { 0x00, 0x00 },
    { 0x03, 0x00 },
    { 0x00, 0x00 },
    { 0x7f, 0x00 },
    { 0x00, 0x02 },
    { CFG_META_BURST, 116 },
    { 0x0c, 0x40 },
    { 0x00, 0x00 },
    { 0x00, 0x7c },
    { 0xb5, 0xae },
    { 0x94, 0x2d },
    { 0x6a, 0x86 },
    { 0x6f, 0x47 },
    { 0x5c, 0x28 },
    { 0xf6, 0x16 },
    { 0x66, 0x66 },
    { 0x66, 0x1a },
    { 0x66, 0x66 },
    { 0x66, 0x08 },
    { 0x00, 0x00 },
    { 0x00, 0x17 },
    { 0x33, 0x33 },
    { 0x33, 0x15 },
    { 0x99, 0x99 },
    { 0x9a, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x40 },
    { 0x00, 0x00 },
    { 0x00, 0x40 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x09 },
    { 0x45, 0x02 },
    { 0x46, 0xb4 },
    { 0xe4, 0x00 },
    { 0x00, 0x12 },
    { 0xc0, 0x7f },
    { 0xfb, 0xb6 },
    { 0x14, 0x80 },
    { 0x04, 0x49 },
    { 0xed, 0x7f },
    { 0xf7, 0x6c },
    { 0x28, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xef },
    { 0x5d, 0x5e },
    { 0x9d, 0x00 },
    { 0x00, 0x03 },
    { CFG_META_BURST, 84 },
    { 0x08, 0xee },
    { 0x8d, 0xef },
    { 0x97, 0x03 },
    { 0xe6, 0x66 },
    { 0x60, 0x03 },
    { 0xe6, 0x66 },
    { 0x60, 0x78 },
    { 0x33, 0x33 },
    { 0x40, 0x72 },
    { 0x14, 0x82 },
    { 0xc0, 0x00 },
    { 0x00, 0x00 },
    { 0x64, 0x40 },
    { 0xbd, 0xb7 },
    { 0xc0, 0x39 },
    { 0x80, 0x00 },
    { 0x00, 0x2d },
    { 0x6a, 0x86 },
    { 0x6f, 0x7c },
    { 0x5e, 0x4e },
    { 0x02, 0x08 },
    { 0x37, 0x6d },
    { 0x54, 0x3e },
    { 0xcd, 0xcb },
    { 0xb8, 0x18 },
    { 0xcc, 0xcc },
    { 0xcc, 0x18 },
    { 0x00, 0x00 },
    { 0x00, 0x17 },
    { 0x33, 0x33 },
    { 0x33, 0x16 },
    { 0x66, 0x66 },
    { 0x66, 0x07 },
    { 0x00, 0x00 },
    { 0x00, 0x06 },
    { 0x00, 0x00 },
    { 0x00, 0x05 },
    { 0x00, 0x00 },
    { 0x00, 0x04 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x30, 0x00 },
    { 0x00, 0x04 },
    { CFG_META_BURST, 76 },
    { 0x34, 0x01 },
    { 0x4e, 0xa3 },
    { 0xf9, 0x00 },
    { 0x3c, 0xcf },
    { 0x7a, 0x01 },
    { 0x4e, 0xa3 },
    { 0xf9, 0x00 },
    { 0x40, 0xfe },
    { 0x54, 0x43 },
    { 0x33, 0x33 },
    { 0x33, 0x48 },
    { 0x20, 0x2d },
    { 0x49, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x01 },
    { 0x99, 0x99 },
    { 0x99, 0x17 },
    { 0x99, 0x99 },
    { 0x9a, 0x17 },
    { 0x99, 0x99 },
    { 0x99, 0x04 },
    { 0xcc, 0xcc },
    { 0xcd, 0x04 },
    { 0xcc, 0xcc },
    { 0xcd, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x73 },
    { 0x33, 0x33 },
    { 0x33, 0x00 },
    { 0x00, 0x00 },
    { 0x27, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xfb, 0xb6 },
    { 0x14, 0x80 },
    { 0x04, 0x49 },
    { 0xec, 0x7f },
    { 0xf7, 0x6c },
    { 0x28, 0x00 },
    { 0x00, 0x05 },
    { CFG_META_BURST, 40 },
    { 0x08, 0x3f },
    { 0xb7, 0x35 },
    { 0x80, 0xc0 },
    { 0x48, 0xca },
    { 0x80, 0x3f },
    { 0xb7, 0x35 },
    { 0x80, 0x7f },
    { 0x6e, 0x33 },
    { 0xba, 0x81 },
    { 0x22, 0xbb },
    { 0x72, 0x00 },
    { 0x00, 0xff },
    { 0xe1, 0x00 },
    { 0x00, 0xff },
    { 0xe1, 0x00 },
    { 0x00, 0xff },
    { 0xe1, 0x7e },
    { 0x94, 0x0d },
    { 0xc3, 0x82 },
    { 0xcf, 0xe5 },
    { 0x74, 0x00 },
    { CFG_META_BURST, 60 },
    { 0x40, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x20 },
    { 0x00, 0x00 },
    { 0x00, 0x5a },
    { 0x82, 0x79 },
    { 0x9a, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xae },
    { 0x83, 0x3e },
    { 0x49, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x7c, 0x02 },
    { 0x1d, 0x9b },
    { 0x7f, 0x00 },
    { 0x00, 0x06 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x03, 0xfa },
    { 0xd1, 0x00 },
    { 0x03, 0xfa },
    { 0xd1, 0x00 },
    { 0x03, 0xfa },
    { 0xd1, 0x7d },
    { 0xf5, 0x67 },
    { 0x97, 0x83 },
    { 0xf5, 0x5a },
    { 0x49, 0x00 },
    { 0xfd, 0x66 },
    { 0x54, 0x00 },
    { 0x7e, 0xb3 },
    { 0x2a, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x3e },
    { 0x05, 0x33 },
    { 0x58, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x07 },
    { CFG_META_BURST, 4 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 116 },
    { 0x0c, 0x04 },
    { 0x00, 0x00 },
    { 0x00, 0x04 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x08 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x80 },
    { 0x89, 0xee },
    { 0x10, 0x7f },
    { 0x72, 0x82 },
    { 0xd7, 0x81 },
    { 0x0c, 0xbd },
    { 0xed, 0x7f },
    { 0x76, 0x11 },
    { 0xf0, 0x7f },
    { 0x76, 0x11 },
    { 0xf0, 0x83 },
    { 0x34, 0x5e },
    { 0x0e, 0x7c },
    { 0xc2, 0xba },
    { 0xfd, 0x86 },
    { 0x56, 0xee },
    { 0x31, 0x7c },
    { 0xcb, 0xa1 },
    { 0xf2, 0x7c },
    { 0xcb, 0xa1 },
    { 0xf2, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x09 },
    { CFG_META_BURST, 12 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 16 },
    { 0x1c, 0x02 },
    { 0x1d, 0x9b },
    { 0x7f, 0x02 },
    { 0x1d, 0x9b },
    { 0x7f, 0x02 },
    { 0x1d, 0x9b },
    { 0x7f, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 8 },
    { 0x34, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x0a },
    { CFG_META_BURST, 80 },
    { 0x30, 0x50 },
    { 0x3c, 0x77 },
    { 0x43, 0xaf },
    { 0xc3, 0x88 },
    { 0xbd, 0x50 },
    { 0x3c, 0x77 },
    { 0x43, 0x46 },
    { 0xfd, 0x9a },
    { 0xc3, 0xcd },
    { 0x09, 0x58 },
    { 0x7b, 0x50 },
    { 0x3c, 0x77 },
    { 0x43, 0xaf },
    { 0xc3, 0x88 },
    { 0xbd, 0x50 },
    { 0x3c, 0x77 },
    { 0x43, 0x46 },
    { 0xfd, 0x9a },
    { 0xc3, 0xcd },
    { 0x09, 0x58 },
    { 0x7b, 0x6e },
    { 0x61, 0x70 },
    { 0x95, 0x89 },
    { 0x76, 0x6e },
    { 0x96, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x76 },
    { 0x89, 0x91 },
    { 0x6a, 0x91 },
    { 0x9e, 0x8f },
    { 0x6b, 0x09 },
    { 0x3e, 0xdc },
    { 0x80, 0x09 },
    { 0x3e, 0xdc },
    { 0x80, 0x09 },
    { 0x3e, 0xdc },
    { 0x80, 0x46 },
    { 0xfd, 0x9a },
    { 0xc3, 0xcd },
    { 0x09, 0x58 },
    { 0x7b, 0x00 },
    { 0x00, 0x0b },
    { CFG_META_BURST, 120 },
    { 0x08, 0x09 },
    { 0x3e, 0xdc },
    { 0x80, 0x09 },
    { 0x3e, 0xdc },
    { 0x80, 0x09 },
    { 0x3e, 0xdc },
    { 0x80, 0x46 },
    { 0xfd, 0x9a },
    { 0xc3, 0xcd },
    { 0x09, 0x58 },
    { 0x7b, 0x76 },
    { 0xdd, 0x24 },
    { 0xda, 0x89 },
    { 0x22, 0xdb },
    { 0x26, 0x76 },
    { 0xdd, 0x24 },
    { 0xda, 0x76 },
    { 0x89, 0x91 },
    { 0x6a, 0x91 },
    { 0x9e, 0x8f },
    { 0x6b, 0x76 },
    { 0xdd, 0x24 },
    { 0xda, 0x89 },
    { 0x22, 0xdb },
    { 0x26, 0x76 },
    { 0xdd, 0x24 },
    { 0xda, 0x76 },
    { 0x89, 0x91 },
    { 0x6a, 0x91 },
    { 0x9e, 0x8f },
    { 0x6b, 0x00 },
    { 0x53, 0x93 },
    { 0x71, 0x00 },
    { 0x53, 0x93 },
    { 0x71, 0x00 },
    { 0x53, 0x93 },
    { 0x71, 0x76 },
    { 0x89, 0x91 },
    { 0x6a, 0x91 },
    { 0x9e, 0x8f },
    { 0x6b, 0x00 },
    { 0x53, 0x93 },
    { 0x71, 0x00 },
    { 0x53, 0x93 },
    { 0x71, 0x00 },
    { 0x53, 0x93 },
    { 0x71, 0x76 },
    { 0x89, 0x91 },
    { 0x6a, 0x91 },
    { 0x9e, 0x8f },
    { 0x6b, 0x04 },
    { 0x00, 0x00 },
    { 0x00, 0x04 },
    { 0x00, 0x00 },
    { 0x00, 0x04 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xe9, 0x3e },
    { 0x94, 0x7f },
    { 0xe9, 0x3e },
    { 0x94, 0x00 },
    { 0x00, 0x0c },
    { CFG_META_BURST, 120 },
    { 0x08, 0x45 },
    { 0x0f, 0x7a },
    { 0x2b, 0x45 },
    { 0x0f, 0x7a },
    { 0x2b, 0x06 },
    { 0x00, 0x00 },
    { 0x00, 0x06 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x80, 0x00 },
    { 0x00, 0x00 },
    { 0xb5, 0x04 },
    { 0xf3, 0x01 },
    { 0x6a, 0x09 },
    { 0xe6, 0x00 },
    { 0x80, 0x00 },
    { 0x00, 0x00 },
    { 0x16, 0xc1 },
    { 0x6c, 0x00 },
    { 0x06, 0xd3 },
    { 0xa0, 0x00 },
    { 0x36, 0x9d },
    { 0x03, 0x00 },
    { 0x6a, 0x21 },
    { 0xd7, 0x01 },
    { 0x3e, 0x65 },
    { 0x85, 0x01 },
    { 0x73, 0x76 },
    { 0x70, 0x02 },
    { 0x12, 0xa9 },
    { 0x32, 0x7f },
    { 0xe9, 0x3e },
    { 0x94, 0x7f },
    { 0xf9, 0x2c },
    { 0x60, 0x7f },
    { 0xf9, 0x2c },
    { 0x60, 0x45 },
    { 0x0f, 0x7a },
    { 0x2b, 0x42 },
    { 0x2d, 0x38 },
    { 0x00, 0x42 },
    { 0x2d, 0x38 },
    { 0x00, 0x06 },
    { 0x00, 0x00 },
    { 0x00, 0x06 },
    { 0x00, 0x00 },
    { 0x00, 0x06 },
    { 0x00, 0x00 },
    { 0x00, 0xc0 },
    { 0x00, 0x00 },
    { 0x00, 0xc0 },
    { 0x00, 0x00 },
    { 0x00, 0xc0 },
    { 0x00, 0x00 },
    { 0x00, 0x40 },
    { 0x00, 0x00 },
    { 0x00, 0x2f },
    { 0x16, 0xac },
    { 0x6c, 0x2f },
    { 0x16, 0xac },
    { 0x6c, 0x00 },
    { 0x00, 0x0d },
    { CFG_META_BURST, 120 },
    { 0x08, 0x01 },
    { 0x00, 0x00 },
    { 0x00, 0x02 },
    { 0x00, 0x00 },
    { 0x00, 0x02 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x04 },
    { 0x00, 0x00 },
    { 0x00, 0x04 },
    { 0x00, 0x40 },
    { 0x00, 0x4f },
    { 0x2f, 0x40 },
    { 0x00, 0x57 },
    { 0x62, 0x40 },
    { 0x00, 0x57 },
    { 0x62, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x16, 0xc1 },
    { 0x6c, 0x00 },
    { 0xfb, 0x4f },
    { 0xf8, 0x0a },
    { 0xbc, 0x26 },
    { 0x7b, 0xf8 },
    { 0xaa, 0xa7 },
    { 0x4f, 0x05 },
    { 0x9e, 0x80 },
    { 0xdd, 0x7b },
    { 0xa9, 0x65 },
    { 0x70, 0x86 },
    { 0xfd, 0x3f },
    { 0x2b, 0xc0 },
    { 0x00, 0x00 },
    { 0x00, 0xc0 },
    { 0x00, 0x00 },
    { 0x00, 0xc0 },
    { 0x00, 0x00 },
    { 0x00, 0xc0 },
    { 0x00, 0x00 },
    { 0x00, 0x40 },
    { 0x00, 0x00 },
    { 0x00, 0x5a },
    { 0x9d, 0xf7 },
    { 0xac, 0x40 },
    { 0x26, 0xe7 },
    { 0x3d, 0x00 },
    { 0x0a, 0xeb },
    { 0xbd, 0xc0 },
    { 0x00, 0x00 },
    { 0x00, 0x13 },
    { 0xa6, 0x7c },
    { 0xa1, 0x02 },
    { 0xae, 0xb7 },
    { 0x0b, 0x00 },
    { 0x00, 0x0e },
    { CFG_META_BURST, 108 },
    { 0x08, 0x7f },
    { 0xfe, 0xfd },
    { 0x47, 0xc0 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xfe },
    { 0xfe, 0xa4 },
    { 0xb4, 0x00 },
    { 0x00, 0x03 },
    { 0x20, 0x10 },
    { 0x00, 0x00 },
    { 0x00, 0x01 },
    { 0x53, 0xe3 },
    { 0x27, 0xfe },
    { 0xdd, 0xf5 },
    { 0xd2, 0x01 },
    { 0x53, 0xe3 },
    { 0x27, 0x7a },
    { 0xef, 0x6e },
    { 0x2a, 0x89 },
    { 0xbd, 0x71 },
    { 0xb9, 0x01 },
    { 0x53, 0xe3 },
    { 0x27, 0xfe },
    { 0xdd, 0xf5 },
    { 0xd2, 0x01 },
    { 0x53, 0xe3 },
    { 0x27, 0x7a },
    { 0xef, 0x6e },
    { 0x2a, 0x89 },
    { 0xbd, 0x71 },
    { 0xb9, 0x01 },
    { 0x53, 0xe3 },
    { 0x27, 0xfe },
    { 0xdd, 0xf5 },
    { 0xd2, 0x01 },
    { 0x53, 0xe3 },
    { 0x27, 0x7a },
    { 0xef, 0x6e },
    { 0x2a, 0x89 },
    { 0xbd, 0x71 },
    { 0xb9, 0x01 },
    { 0x53, 0xe3 },
    { 0x27, 0xfe },
    { 0xdd, 0xf5 },
    { 0xd2, 0x01 },
    { 0x53, 0xe3 },
    { 0x27, 0x7a },
    { 0xef, 0x6e },
    { 0x2a, 0x89 },
    { 0xbd, 0x71 },
    { 0xb9, 0x7d },
    { 0x51, 0x48 },
    { 0xf5, 0x00 },
    { CFG_META_BURST, 8 },
    { 0x74, 0x12 },
    { 0x49, 0x24 },
    { 0x92, 0x00 },
    { 0x10, 0x9d },
    { 0x7f, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x7c, 0xf9 },
    { 0xa9, 0x83 },
    { 0x86, 0x00 },
    { 0x00, 0x0f },
    { CFG_META_BURST, 120 },
    { 0x08, 0x05 },
    { 0x05, 0x61 },
    { 0xb2, 0x02 },
    { 0xfa, 0x9e },
    { 0x4e, 0x06 },
    { 0x82, 0xb0 },
    { 0xd9, 0x00 },
    { 0xaa, 0xbb },
    { 0x48, 0x00 },
    { 0x00, 0x38 },
    { 0x45, 0x00 },
    { 0x04, 0xc5 },
    { 0xe7, 0x00 },
    { 0x06, 0xf6 },
    { 0xf7, 0x03 },
    { 0xcf, 0xc1 },
    { 0x81, 0x03 },
    { 0x51, 0x7b },
    { 0x36, 0x40 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x35 },
    { 0xa2, 0x68 },
    { 0x0a, 0x00 },
    { 0x1c, 0xee },
    { 0xa1, 0x00 },
    { 0x0a, 0x5c },
    { 0xb6, 0x13 },
    { 0x17, 0x9c },
    { 0x05, 0x4b },
    { 0xc1, 0xf0 },
    { 0x7c, 0x2b },
    { 0x03, 0xc9 },
    { 0x33, 0x00 },
    { 0x19, 0xbb },
    { 0x01, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xff },
    { 0xe6, 0x44 },
    { 0xff, 0x7f },
    { 0xf8, 0x8e },
    { 0x94, 0x80 },
    { 0x0c, 0xdd },
    { 0x80, 0x40 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x02, 0xbb },
    { 0x06, 0x00 },
    { 0x02, 0xbb },
    { 0x06, 0x00 },
    { 0x00, 0x17 },
    { 0x4d, 0x00 },
    { 0x24, 0x63 },
    { 0x80, 0x00 },
    { 0x0d, 0xa6 },
    { 0x86, 0x01 },
    { 0x6f, 0xa9 },
    { 0xbb, 0x00 },
    { 0x0a, 0xeb },
    { 0xbd, 0x00 },
    { 0x00, 0x10 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x05, 0x75 },
    { 0xfc, 0x00 },
    { 0x24, 0x63 },
    { 0x80, 0x00 },
    { 0x24, 0x63 },
    { 0x80, 0x2e },
    { 0xe0, 0x00 },
    { 0x00, 0x02 },
    { 0x49, 0xfe },
    { 0xde, 0x23 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x3e, 0x81 },
    { 0x96, 0x00 },
    { 0x09, 0x4a },
    { 0x0f, 0x7f },
    { 0xf6, 0xb5 },
    { 0xf1, 0x00 },
    { 0x02, 0x11 },
    { 0x49, 0x02 },
    { 0x1d, 0x9b },
    { 0x7f, 0x7d },
    { 0xe2, 0x64 },
    { 0x81, 0x07 },
    { 0x2c, 0x22 },
    { 0xeb, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x44 },
    { 0xe1, 0xdd },
    { 0x40, 0x48 },
    { 0x48, 0x7c },
    { 0xc1, 0x1d },
    { 0x74, 0xd2 },
    { 0x38, 0xc4 },
    { 0xa2, 0xd8 },
    { 0xae, 0x08 },
    { 0x8d, 0x85 },
    { 0xc9, 0x01 },
    { 0x4c, 0xf6 },
    { 0x3a, 0xff },
    { 0x40, 0xaf },
    { 0x3c, 0x01 },
    { 0x4c, 0xf6 },
    { 0x3a, 0x68 },
    { 0x36, 0x21 },
    { 0xbc, 0xaa },
    { 0x5b, 0x9d },
    { 0xf3, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x8b },
    { 0x57, 0x50 },
    { 0x3c, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x75 },
    { 0x83, 0x0e },
    { 0x39, 0x90 },
    { 0x2a, 0xba },
    { 0xff, 0x00 },
    { 0x00, 0x11 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x08 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x03, 0x46 },
    { 0xdc, 0x08 },
    { 0xc2, 0xf1 },
    { 0x47, 0xf9 },
    { 0x49, 0x72 },
    { 0xed, 0x05 },
    { 0x41, 0x60 },
    { 0xdc, 0x01 },
    { 0xf0, 0x89 },
    { 0xa8, 0x01 },
    { 0xfa, 0x91 },
    { 0x9b, 0x00 },
    { 0x00, 0x53 },
    { 0xe3, 0x00 },
    { 0x03, 0x46 },
    { 0xdc, 0x08 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x39 },
    { 0x7f, 0x06 },
    { 0xfd, 0xc8 },
    { 0xf4, 0x06 },
    { 0x39, 0x0a },
    { 0x9d, 0x00 },
    { 0x0a, 0xeb },
    { 0xbd, 0x01 },
    { 0x0f, 0xee },
    { 0x9a, 0x00 },
    { 0x1c, 0xee },
    { 0xa1, 0x00 },
    { 0x2b, 0xa9 },
    { 0x5c, 0x7f },
    { 0xd4, 0x56 },
    { 0xa4, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x39 },
    { 0x7f, 0x01 },
    { 0xca, 0x7f },
    { 0x3d, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x12 },
    { CFG_META_BURST, 44 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x01 },
    { 0x01, 0x37 },
    { 0x98, 0x7f },
    { 0xff, 0x51 },
    { 0x3d, 0x41 },
    { 0x18, 0x23 },
    { 0xc9, 0x01 },
    { 0x53, 0xe3 },
    { 0x27, 0xfe },
    { 0xdd, 0xf5 },
    { 0xd3, 0x01 },
    { 0x53, 0xe3 },
    { 0x27, 0x7a },
    { 0xef, 0x6e },
    { 0x2a, 0x89 },
    { 0xbd, 0x71 },
    { 0xba, 0x06 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 76 },
    { 0x34, 0x00 },
    { 0x01, 0x62 },
    { 0xb2, 0x00 },
    { 0x01, 0x62 },
    { 0xb2, 0x00 },
    { 0x01, 0x62 },
    { 0xb2, 0x7e },
    { 0x55, 0xd9 },
    { 0xd6, 0x83 },
    { 0x4e, 0xc1 },
    { 0x8d, 0x7e },
    { 0x57, 0x3c },
    { 0x89, 0x81 },
    { 0xa8, 0xc3 },
    { 0x77, 0x7e },
    { 0x57, 0x3c },
    { 0x89, 0x7e },
    { 0x55, 0xd9 },
    { 0xd7, 0x83 },
    { 0x4e, 0xc1 },
    { 0x8c, 0x7e },
    { 0x57, 0x3c },
    { 0x88, 0x81 },
    { 0xa8, 0xc3 },
    { 0x78, 0x7e },
    { 0x57, 0x3c },
    { 0x88, 0x7e },
    { 0x55, 0xd9 },
    { 0xd6, 0x83 },
    { 0x4e, 0xc1 },
    { 0x8d, 0x00 },
    { 0x01, 0x62 },
    { 0xb2, 0x00 },
    { 0x01, 0x62 },
    { 0xb2, 0x00 },
    { 0x01, 0x62 },
    { 0xb2, 0x7e },
    { 0x55, 0xd9 },
    { 0xd6, 0x00 },
    { 0x00, 0x13 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x83 },
    { 0x4e, 0xc1 },
    { 0x8d, 0x5e },
    { 0x4b, 0x35 },
    { 0x77, 0xa1 },
    { 0xb4, 0xca },
    { 0x89, 0x5e },
    { 0x4b, 0x35 },
    { 0x77, 0x5b },
    { 0xb9, 0x37 },
    { 0x7c, 0xbe },
    { 0x45, 0x99 },
    { 0x1a, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xae },
    { 0xc3, 0x7e },
    { 0x57, 0x3c },
    { 0x88, 0x81 },
    { 0xa8, 0xc3 },
    { 0x78, 0x7e },
    { 0x57, 0x3c },
    { 0x88, 0x7e },
    { 0x55, 0xd9 },
    { 0xd6, 0x83 },
    { 0x4e, 0xc1 },
    { 0x8d, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xae },
    { 0xc3, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x20 },
    { 0x00, 0x00 },
    { 0x00, 0xe0 },
    { 0x00, 0x00 },
    { 0x00, 0xe0 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xae },
    { 0xc3, 0x00 },
    { 0x02, 0xbb },
    { 0x06, 0x00 },
    { 0x00, 0x57 },
    { 0x62, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x14 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xf9 },
    { 0x58, 0xfb },
    { 0xa9, 0xfb },
    { 0xd6, 0xcb },
    { 0x11, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xf7 },
    { 0x45, 0x79 },
    { 0x7c, 0xf6 },
    { 0xdb, 0x2c },
    { 0x40, 0x00 },
    { 0x20, 0x26 },
    { 0xf3, 0x00 },
    { 0x00, 0xbb },
    { 0x80, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xae },
    { 0xc3, 0x00 },
    { 0x02, 0xbb },
    { 0x06, 0x00 },
    { 0x00, 0x57 },
    { 0x62, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xf9 },
    { 0x58, 0xfb },
    { 0xa9, 0xfb },
    { 0xd6, 0xcb },
    { 0x11, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xf7 },
    { 0x45, 0x79 },
    { 0x7c, 0xf6 },
    { 0xdb, 0x2c },
    { 0x40, 0x00 },
    { 0x20, 0x26 },
    { 0xf3, 0x00 },
    { 0x00, 0xbb },
    { 0x80, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xae },
    { 0xc3, 0x00 },
    { 0x02, 0xbb },
    { 0x06, 0x00 },
    { 0x00, 0x57 },
    { 0x62, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x15 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xf9 },
    { 0x58, 0xfb },
    { 0xa9, 0xfb },
    { 0xd6, 0xcb },
    { 0x11, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xf7 },
    { 0x45, 0x79 },
    { 0x7c, 0xf6 },
    { 0xdb, 0x2c },
    { 0x40, 0x00 },
    { 0x20, 0x26 },
    { 0xf3, 0x00 },
    { 0x00, 0xbb },
    { 0x80, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x16 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x17 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x18 },
    { CFG_META_BURST, 64 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 56 },
    { 0x48, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x0f, 0x00 },
    { 0x00, 0x00 },
    { 0x05, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x01 },
    { 0x90, 0x00 },
    { 0x00, 0x00 },
    { 0x0d, 0x00 },
    { 0x00, 0x00 },
    { 0x03, 0x00 },
    { 0x00, 0x01 },
    { 0x98, 0x00 },
    { 0x00, 0x01 },
    { 0xa0, 0x00 },
    { 0x00, 0x01 },
    { 0xa8, 0x00 },
    { 0x00, 0x00 },
    { 0x15, 0x00 },
    { 0x00, 0x00 },
    { 0x03, 0x00 },
    { 0x00, 0x02 },
    { 0x40, 0x00 },
    { 0x00, 0x19 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x00, 0x02 },
    { 0x20, 0xa0 },
    { 0x00, 0x00 },
    { 0x04, 0x00 },
    { 0x00, 0x00 },
    { 0x1f, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x06 },
    { 0xa0, 0x00 },
    { 0x00, 0x00 },
    { 0x25, 0x00 },
    { 0x00, 0x00 },
    { 0x03, 0x00 },
    { 0x00, 0x02 },
    { 0x18, 0x00 },
    { 0x00, 0x02 },
    { 0x60, 0x00 },
    { 0x00, 0x02 },
    { 0x68, 0x00 },
    { 0x00, 0x00 },
    { 0x54, 0x00 },
    { 0x00, 0x00 },
    { 0x29, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x40 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7c },
    { 0x5e, 0x4e },
    { 0x02, 0x40 },
    { 0x00, 0x03 },
    { 0xee, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x78 },
    { 0xd6, 0xfc },
    { 0x9f, 0x00 },
    { 0x33, 0x33 },
    { 0x33, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x20 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x20 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x1a },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x8a, 0x00 },
    { 0x00, 0x00 },
    { 0x05, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x0d },
    { 0x86, 0x94 },
    { 0x7f, 0x0d },
    { 0x86, 0x94 },
    { 0x7f, 0x00 },
    { 0x00, 0x1b },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x99, 0x00 },
    { 0x00, 0x00 },
    { 0x04, 0x00 },
    { 0x00, 0x00 },
    { 0x30, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x07 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0xa9, 0x00 },
    { 0x00, 0x00 },
    { 0x05, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x80, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xbb },
    { 0x80, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x01 },
    { 0xb0, 0x00 },
    { 0x00, 0x00 },
    { 0x10, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x1c },
    { CFG_META_BURST, 120 },
    { 0x08, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x02 },
    { 0x3a, 0x00 },
    { 0x00, 0x00 },
    { 0x05, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x80, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xbb },
    { 0x80, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x02 },
    { 0x5a, 0x00 },
    { 0x00, 0x00 },
    { 0x05, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x80, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xbb },
    { 0x80, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x02 },
    { 0x74, 0x00 },
    { 0x00, 0x00 },
    { 0x04, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x06 },
    { 0xeb, 0x00 },
    { 0x00, 0x00 },
    { 0x04, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x07 },
    { 0xf4, 0x00 },
    { 0x00, 0x00 },
    { 0x35, 0x00 },
    { 0x00, 0x03 },
    { 0x88, 0x00 },
    { 0x00, 0x1d },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x06, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x02, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x04 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x00 },
    { 0x07, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x03, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x01 },
    { 0xe0, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x03, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x05, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x02 },
    { 0x88, 0x00 },
    { 0x00, 0x00 },
    { 0x07, 0x00 },
    { 0x00, 0x00 },
    { 0x03, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x01 },
    { 0xc0, 0x00 },
    { 0x00, 0x1e },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x00 },
    { 0x03, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x00 },
    { 0x03, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x01 },
    { 0xb0, 0x00 },
    { 0x00, 0x00 },
    { 0x03, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x03, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x01 },
    { 0xb8, 0x00 },
    { 0x00, 0x00 },
    { 0x03, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x04, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x00 },
    { 0x05, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x07 },
    { 0xf4, 0x00 },
    { 0x00, 0x00 },
    { 0x22, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x05, 0x00 },
    { 0x00, 0x00 },
    { 0x06, 0x00 },
    { 0x00, 0x00 },
    { 0x07, 0x00 },
    { 0x00, 0x00 },
    { 0x10, 0x00 },
    { 0x00, 0x00 },
    { 0x05, 0x00 },
    { 0x00, 0x00 },
    { 0x18, 0x00 },
    { 0x00, 0x1f },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x07, 0x00 },
    { 0x00, 0x00 },
    { 0x20, 0x00 },
    { 0x00, 0x00 },
    { 0x05, 0x00 },
    { 0x00, 0x00 },
    { 0x28, 0x00 },
    { 0x00, 0x00 },
    { 0x2b, 0x00 },
    { 0x00, 0x00 },
    { 0x90, 0x00 },
    { 0x00, 0x00 },
    { 0x09, 0x00 },
    { 0x00, 0x00 },
    { 0xa0, 0x00 },
    { 0x00, 0x00 },
    { 0x09, 0x00 },
    { 0x00, 0x00 },
    { 0xb0, 0x00 },
    { 0x00, 0x00 },
    { 0x07, 0x00 },
    { 0x00, 0x00 },
    { 0xb8, 0x00 },
    { 0x00, 0x00 },
    { 0x07, 0x00 },
    { 0x00, 0x00 },
    { 0xc0, 0x00 },
    { 0x00, 0x00 },
    { 0x07, 0x00 },
    { 0x00, 0x00 },
    { 0xc8, 0x00 },
    { 0x00, 0x00 },
    { 0x07, 0x00 },
    { 0x00, 0x00 },
    { 0xd0, 0x00 },
    { 0x00, 0x00 },
    { 0x07, 0x00 },
    { 0x00, 0x00 },
    { 0xd8, 0x00 },
    { 0x00, 0x00 },
    { 0x07, 0x00 },
    { 0x00, 0x00 },
    { 0xe0, 0x00 },
    { 0x00, 0x00 },
    { 0x05, 0x00 },
    { 0x00, 0x00 },
    { 0xe8, 0x00 },
    { 0x00, 0x00 },
    { 0x05, 0x00 },
    { 0x00, 0x00 },
    { 0xf0, 0x00 },
    { 0x00, 0x00 },
    { 0x05, 0x00 },
    { 0x00, 0x00 },
    { 0xf8, 0x00 },
    { 0x00, 0x00 },
    { 0x05, 0x00 },
    { 0x00, 0x01 },
    { 0x00, 0x00 },
    { 0x00, 0x20 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x85, 0x00 },
    { 0x00, 0x01 },
    { 0x88, 0x00 },
    { 0x00, 0x00 },
    { 0x05, 0x00 },
    { 0x00, 0x01 },
    { 0x90, 0x00 },
    { 0x00, 0x00 },
    { 0x05, 0x00 },
    { 0x00, 0x01 },
    { 0x98, 0x00 },
    { 0x00, 0x00 },
    { 0x05, 0x00 },
    { 0x00, 0x01 },
    { 0xa0, 0x00 },
    { 0x00, 0x00 },
    { 0x05, 0x00 },
    { 0x00, 0x01 },
    { 0xa8, 0x00 },
    { 0x00, 0x00 },
    { 0x05, 0x00 },
    { 0x00, 0x01 },
    { 0xc0, 0x00 },
    { 0x00, 0x00 },
    { 0x56, 0x00 },
    { 0x00, 0x02 },
    { 0x18, 0x00 },
    { 0x00, 0x00 },
    { 0x05, 0x00 },
    { 0x00, 0x02 },
    { 0x20, 0x00 },
    { 0x00, 0x00 },
    { 0x1a, 0x00 },
    { 0x00, 0x02 },
    { 0x40, 0x00 },
    { 0x00, 0x00 },
    { 0x1a, 0x00 },
    { 0x00, 0x02 },
    { 0x60, 0x00 },
    { 0x00, 0x00 },
    { 0x07, 0x00 },
    { 0x00, 0x02 },
    { 0x68, 0x00 },
    { 0x00, 0x00 },
    { 0x05, 0x00 },
    { 0x00, 0x02 },
    { 0x78, 0x00 },
    { 0x00, 0x04 },
    { 0x25, 0x00 },
    { 0x00, 0x06 },
    { 0xa0, 0x00 },
    { 0x00, 0x00 },
    { 0x4b, 0x00 },
    { 0x00, 0x06 },
    { 0xef, 0x00 },
    { 0x00, 0x01 },
    { 0x05, 0x00 },
    { 0x00, 0x08 },
    { 0x29, 0x00 },
    { 0x00, 0x21 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x04, 0x00 },
    { 0x00, 0x00 },
    { 0x09, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x00 },
    { 0x32, 0x40 },
    { 0x00, 0x00 },
    { 0x00, 0x03 },
    { 0x4a, 0x51 },
    { 0x6c, 0x2d },
    { 0x6a, 0x86 },
    { 0x6f, 0x47 },
    { 0x5c, 0x28 },
    { 0xf6, 0x16 },
    { 0x66, 0x66 },
    { 0x66, 0x1a },
    { 0x66, 0x66 },
    { 0x66, 0x10 },
    { 0x00, 0x00 },
    { 0x00, 0x17 },
    { 0x33, 0x33 },
    { 0x33, 0x15 },
    { 0x99, 0x99 },
    { 0x9a, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x40 },
    { 0x00, 0x00 },
    { 0x00, 0x40 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x09 },
    { 0x45, 0x02 },
    { 0x46, 0xb4 },
    { 0xe4, 0x00 },
    { 0x00, 0x4b },
    { 0x00, 0x7f },
    { 0xfb, 0xb6 },
    { 0x14, 0x80 },
    { 0x04, 0x49 },
    { 0xec, 0x7f },
    { 0xf7, 0x6c },
    { 0x28, 0x00 },
    { 0x00, 0x22 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xef },
    { 0x5d, 0x5e },
    { 0x9d, 0xee },
    { 0x8d, 0xef },
    { 0x97, 0x03 },
    { 0xe6, 0x66 },
    { 0x60, 0x03 },
    { 0xe6, 0x66 },
    { 0x60, 0x78 },
    { 0x33, 0x33 },
    { 0x40, 0x72 },
    { 0x14, 0x82 },
    { 0xc0, 0x00 },
    { 0x00, 0x02 },
    { 0x58, 0x40 },
    { 0xbd, 0xb7 },
    { 0xc0, 0x39 },
    { 0x82, 0x60 },
    { 0x7f, 0x2d },
    { 0x6a, 0x86 },
    { 0x6f, 0x7c },
    { 0x5e, 0x4e },
    { 0x02, 0x08 },
    { 0x37, 0x6d },
    { 0x54, 0x3e },
    { 0xcd, 0xcb },
    { 0xb8, 0x18 },
    { 0xcc, 0xcc },
    { 0xcc, 0x18 },
    { 0x00, 0x00 },
    { 0x00, 0x17 },
    { 0x33, 0x33 },
    { 0x33, 0x16 },
    { 0x66, 0x66 },
    { 0x66, 0x07 },
    { 0x00, 0x00 },
    { 0x00, 0x06 },
    { 0x00, 0x00 },
    { 0x00, 0x05 },
    { 0x00, 0x00 },
    { 0x00, 0x04 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x30, 0x00 },
    { 0x00, 0x00 },
    { 0x47, 0x00 },
    { 0x00, 0x00 },
    { 0x1d, 0x01 },
    { 0x4e, 0xa3 },
    { 0xf9, 0x00 },
    { 0x4c, 0xcf },
    { 0x7a, 0x01 },
    { 0x4e, 0xa3 },
    { 0xf9, 0x00 },
    { 0x50, 0xfe },
    { 0x54, 0x00 },
    { 0x00, 0x23 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x43 },
    { 0x33, 0x33 },
    { 0x33, 0x48 },
    { 0x20, 0x2d },
    { 0x49, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x01 },
    { 0x99, 0x99 },
    { 0x99, 0x17 },
    { 0x99, 0x99 },
    { 0x99, 0x17 },
    { 0x99, 0x99 },
    { 0x99, 0x00 },
    { 0xcc, 0xcc },
    { 0xcc, 0x02 },
    { 0x66, 0x66 },
    { 0x66, 0x01 },
    { 0x99, 0x99 },
    { 0x99, 0x73 },
    { 0x33, 0x33 },
    { 0x33, 0x00 },
    { 0x00, 0x00 },
    { 0x19, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xfb, 0xb6 },
    { 0x14, 0x80 },
    { 0x04, 0x49 },
    { 0xec, 0x7f },
    { 0xf7, 0x6c },
    { 0x28, 0x3f },
    { 0xdb, 0x8c },
    { 0xf1, 0xc0 },
    { 0x24, 0x73 },
    { 0x0f, 0x3f },
    { 0xdb, 0x8c },
    { 0xf1, 0x7f },
    { 0xb7, 0x0c },
    { 0x09, 0x80 },
    { 0x91, 0xb0 },
    { 0x89, 0x00 },
    { 0x00, 0x40 },
    { 0x53, 0x00 },
    { 0x00, 0x40 },
    { 0x53, 0x00 },
    { 0x00, 0x40 },
    { 0x53, 0x7f },
    { 0x4a, 0x05 },
    { 0x79, 0x81 },
    { 0x69, 0xf2 },
    { 0x78, 0x00 },
    { 0x00, 0x00 },
    { 0x68, 0x00 },
    { 0x00, 0x00 },
    { 0x0e, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x24 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x5a },
    { 0x82, 0x79 },
    { 0x9a, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xae },
    { 0x83, 0x3e },
    { 0x49, 0x00 },
    { 0x00, 0x00 },
    { 0x77, 0x00 },
    { 0x00, 0x00 },
    { 0x18, 0x02 },
    { 0x1d, 0x9b },
    { 0x7f, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x01, 0x00 },
    { 0xb4, 0x00 },
    { 0x00, 0x25 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x01, 0x00 },
    { 0xb4, 0x00 },
    { 0x01, 0x00 },
    { 0xb4, 0x7e },
    { 0xfc, 0xa5 },
    { 0x4c, 0x81 },
    { 0xfe, 0xaf },
    { 0xc6, 0x00 },
    { 0x7f, 0xad },
    { 0xf2, 0x00 },
    { 0x3f, 0xd6 },
    { 0xf9, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x97, 0x00 },
    { 0x00, 0x00 },
    { 0x3e, 0x04 },
    { 0x00, 0x00 },
    { 0x00, 0x04 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x26 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x80 },
    { 0x89, 0xee },
    { 0x10, 0x7f },
    { 0x72, 0x82 },
    { 0xd7, 0x81 },
    { 0x0c, 0xbd },
    { 0xed, 0x7f },
    { 0x76, 0x11 },
    { 0xf0, 0x7f },
    { 0x76, 0x11 },
    { 0xf0, 0x83 },
    { 0x34, 0x5e },
    { 0x0e, 0x7c },
    { 0xc2, 0xba },
    { 0xfd, 0x86 },
    { 0x56, 0xee },
    { 0x31, 0x7c },
    { 0xcb, 0xa1 },
    { 0xf2, 0x7c },
    { 0xcb, 0xa1 },
    { 0xf2, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x27 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x7f },
    { 0xff, 0xff },
    { 0xff, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0xd7, 0x00 },
    { 0x00, 0x00 },
    { 0x04, 0x02 },
    { 0x1d, 0x9b },
    { 0x7f, 0x02 },
    { 0x1d, 0x9b },
    { 0x7f, 0x02 },
    { 0x1d, 0x9b },
    { 0x7f, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0xdd, 0x00 },
    { 0x00, 0x00 },
    { 0x02, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x01 },
    { 0x83, 0x00 },
    { 0x00, 0x00 },
    { 0x02, 0x11 },
    { 0x1a, 0xcc },
    { 0x2e, 0x00 },
    { 0x0b, 0x5a },
    { 0xa7, 0x00 },
    { 0x00, 0x01 },
    { 0xeb, 0x00 },
    { 0x00, 0x00 },
    { 0x59, 0x00 },
    { 0x01, 0x62 },
    { 0xb2, 0x00 },
    { 0x01, 0x62 },
    { 0xb2, 0x00 },
    { 0x01, 0x62 },
    { 0xb2, 0x00 },
    { 0x00, 0x28 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x7e },
    { 0x55, 0xd9 },
    { 0xd7, 0x83 },
    { 0x4e, 0xc1 },
    { 0x8c, 0x7e },
    { 0x57, 0x3c },
    { 0x89, 0x81 },
    { 0xa8, 0xc3 },
    { 0x77, 0x7e },
    { 0x57, 0x3c },
    { 0x89, 0x7e },
    { 0x55, 0xd9 },
    { 0xd7, 0x83 },
    { 0x4e, 0xc1 },
    { 0x8c, 0x7e },
    { 0x57, 0x3c },
    { 0x89, 0x81 },
    { 0xa8, 0xc3 },
    { 0x77, 0x7e },
    { 0x57, 0x3c },
    { 0x89, 0x7e },
    { 0x55, 0xd9 },
    { 0xd7, 0x83 },
    { 0x4e, 0xc1 },
    { 0x8c, 0x02 },
    { 0x91, 0xfd },
    { 0xfc, 0x02 },
    { 0x91, 0xfd },
    { 0xfc, 0x02 },
    { 0x91, 0xfd },
    { 0xfc, 0x5b },
    { 0xb9, 0x37 },
    { 0x7c, 0xbe },
    { 0x45, 0x99 },
    { 0x1a, 0x5e },
    { 0x4b, 0x35 },
    { 0x77, 0xa1 },
    { 0xb4, 0xca },
    { 0x89, 0x5e },
    { 0x4b, 0x35 },
    { 0x77, 0x5b },
    { 0xb9, 0x37 },
    { 0x7c, 0xbe },
    { 0x45, 0x99 },
    { 0x1a, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xae },
    { 0xc3, 0x5e },
    { 0x4b, 0x35 },
    { 0x77, 0xa1 },
    { 0xb4, 0xca },
    { 0x89, 0x5e },
    { 0x4b, 0x35 },
    { 0x77, 0x00 },
    { 0x00, 0x29 },
    { CFG_META_BURST, 120 },
    { 0x08, 0x5b },
    { 0xb9, 0x37 },
    { 0x7c, 0xbe },
    { 0x45, 0x99 },
    { 0x1a, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xae },
    { 0xc3, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xae },
    { 0xc3, 0x00 },
    { 0x02, 0xbb },
    { 0x06, 0x00 },
    { 0x00, 0x57 },
    { 0x62, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xff },
    { 0xc0, 0x00 },
    { 0x00, 0xf9 },
    { 0x58, 0xfb },
    { 0xa8, 0xfb },
    { 0xd6, 0xcb },
    { 0x10, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xf7 },
    { 0x45, 0x79 },
    { 0x7c, 0xf6 },
    { 0xdb, 0x2c },
    { 0x40, 0x00 },
    { 0x20, 0x26 },
    { 0xf3, 0x00 },
    { 0x00, 0x01 },
    { 0xe0, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0xae },
    { 0xc3, 0x00 },
    { 0x02, 0xbb },
    { 0x06, 0x00 },
    { 0x00, 0x57 },
    { 0x62, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x2a },
    { CFG_META_BURST, 120 },
    { 0x08, 0xff },
    { 0xc0, 0x00 },
    { 0x00, 0xff },
    { 0xa0, 0x00 },
    { 0x00, 0xfb },
    { 0x02, 0x30 },
    { 0x98, 0xfb },
    { 0xd6, 0xcb },
    { 0x10, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xff },
    { 0x95, 0xb2 },
    { 0xc4, 0xf7 },
    { 0x45, 0x79 },
    { 0x7c, 0xf6 },
    { 0xdb, 0x2c },
    { 0x40, 0x00 },
    { 0x20, 0x26 },
    { 0xf3, 0x00 },
    { 0x00, 0x01 },
    { 0xe0, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0xae },
    { 0xc3, 0x00 },
    { 0x02, 0xbb },
    { 0x06, 0x00 },
    { 0x00, 0x57 },
    { 0x62, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xff },
    { 0xa0, 0x00 },
    { 0x00, 0xff },
    { 0x81, 0x47 },
    { 0xae, 0xf8 },
    { 0x84, 0x61 },
    { 0x30, 0xfb },
    { 0xd6, 0xcb },
    { 0x10, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xfd },
    { 0x82, 0x30 },
    { 0x98, 0xf7 },
    { 0x45, 0x79 },
    { 0x7c, 0xf6 },
    { 0xdb, 0x2c },
    { 0x40, 0x00 },
    { 0x20, 0x26 },
    { 0xf3, 0x00 },
    { 0x00, 0x01 },
    { 0xe0, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x00 },
    { 0x03, 0x00 },
    { 0x00, 0x00 },
    { 0x76, 0x00 },
    { 0x00, 0x00 },
    { 0x01, 0x00 },
    { 0x00, 0x00 },
    { 0x8f, 0x00 },
    { 0x00, 0x2b },
    { CFG_META_BURST, 20 },
    { 0x08, 0x00 },
    { 0x00, 0x00 },
    { 0x08, 0x00 },
    { 0x00, 0x02 },
    { 0x44, 0x00 },
    { 0x00, 0x00 },
    { 0x60, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0xfd },
    { 0x0d, 0x0d },
    { 0x3a, 0x64 },
    { 0x3b, 0x64 },
    { 0x00, 0x00 },
    { 0x0a, 0x03 },
    { 0x1a, 0xfc },
    { 0x1b, 0xa6 },
    { 0x1c, 0xdf },
    { 0x1d, 0xff },
    { 0x30, 0x19 },
    { 0x32, 0x80 },
    { 0x38, 0x21 },
    { 0x30, 0x19 },
    { 0x33, 0x34 },
    { 0x34, 0x4b },
    { 0x35, 0xa4 },
    { 0x3c, 0x54 },
    { 0x00, 0x04 },
    { CFG_META_BURST, 4 },
    { 0x60, 0x04 },
    { 0xcc, 0xcc },
    { 0xcd, 0x00 },
    { CFG_META_BURST, 48 },
    { 0x14, 0x1c },
    { 0x94, 0x7a },
    { 0xe1, 0x1f },
    { 0xa3, 0xd7 },
    { 0x0a, 0x22 },
    { 0xb3, 0x33 },
    { 0x33, 0x25 },
    { 0xc2, 0x8f },
    { 0x5c, 0x28 },
    { 0xd1, 0xeb },
    { 0x85, 0x2b },
    { 0xe1, 0x47 },
    { 0xae, 0x2e },
    { 0xf0, 0xa3 },
    { 0xd7, 0x32 },
    { 0x00, 0x00 },
    { 0x00, 0x01 },
    { 0x4e, 0xa3 },
    { 0xf9, 0x00 },
    { 0x3c, 0xcf },
    { 0x7a, 0x01 },
    { 0x4e, 0xa3 },
    { 0xf9, 0x00 },
    { 0x40, 0xfe },
    { 0x54, 0x00 },
    { 0x00, 0x03 },
    { CFG_META_BURST, 4 },
    { 0x5c, 0x1e },
    { 0x2e, 0x14 },
    { 0x7b, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x60, 0x21 },
    { 0x3d, 0x70 },
    { 0xa4, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x64, 0x24 },
    { 0x4c, 0xcc },
    { 0xcd, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x68, 0x27 },
    { 0x5c, 0x28 },
    { 0xf6, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x6c, 0x2a },
    { 0x6b, 0x85 },
    { 0x1f, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x70, 0x2d },
    { 0x7a, 0xe1 },
    { 0x48, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x74, 0x30 },
    { 0x8a, 0x3d },
    { 0x71, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x78, 0x33 },
    { 0x99, 0x99 },
    { 0x9a, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x7c, 0x36 },
    { 0xa8, 0xf5 },
    { 0xc3, 0x00 },
    { 0x00, 0x04 },
    { CFG_META_BURST, 4 },
    { 0x08, 0x39 },
    { 0xb8, 0x51 },
    { 0xec, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x0c, 0x3c },
    { 0xc7, 0xae },
    { 0x14, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x10, 0x3f },
    { 0xd7, 0x0a },
    { 0x3d, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x54, 0x17 },
    { 0x99, 0x99 },
    { 0x9a, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x6c, 0x00 },
    { 0x00, 0x00 },
    { 0x27, 0x00 },
    { 0x00, 0x00 },
    { 0x04, 0xc6 },
    { 0x0a, 0x03 },
    { 0x12, 0x12 },
    { 0x13, 0x76 },
    { 0x14, 0x01 },
    { 0x15, 0x2e },
    { 0x17, 0x0e },
    { 0x19, 0x00 },
    { 0x33, 0x34 },
    { 0x34, 0x4b },
    { 0x3b, 0x58 },
    { 0x3e, 0x10 },
    { 0x40, 0x76 },
    { 0x00, 0x01 },
    { 0x08, 0x40 },
    { 0x00, 0x02 },
    { CFG_META_BURST, 4 },
    { 0x0c, 0x40 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x10, 0x7c },
    { 0xb5, 0xae },
    { 0x94, 0x00 },
    { CFG_META_BURST, 12 },
    { 0x68, 0x7f },
    { 0xfb, 0xb6 },
    { 0x14, 0x80 },
    { 0x04, 0x49 },
    { 0xed, 0x7f },
    { 0xf7, 0x6c },
    { 0x28, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x14, 0x2d },
    { 0x6a, 0x86 },
    { 0x6f, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x18, 0x47 },
    { 0x5c, 0x28 },
    { 0xf6, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x1c, 0x16 },
    { 0x66, 0x66 },
    { 0x66, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x20, 0x1a },
    { 0x66, 0x66 },
    { 0x66, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x24, 0x08 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x28, 0x17 },
    { 0x33, 0x33 },
    { 0x33, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x2c, 0x15 },
    { 0x99, 0x99 },
    { 0x9a, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x5c, 0x00 },
    { 0x01, 0x09 },
    { 0x45, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x64, 0x00 },
    { 0x00, 0x12 },
    { 0xc0, 0x00 },
    { 0x00, 0x04 },
    { CFG_META_BURST, 4 },
    { 0x64, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x40, 0x00 },
    { 0x40, 0xfe },
    { 0x54, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x4c, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x00 },
    { 0x00, 0x03 },
    { CFG_META_BURST, 4 },
    { 0x24, 0x39 },
    { 0x80, 0x00 },
    { 0x00, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x18, 0x72 },
    { 0x14, 0x82 },
    { 0xc0, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x1c, 0x00 },
    { 0x00, 0x00 },
    { 0x64, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x20, 0x40 },
    { 0xbd, 0xb7 },
    { 0xc0, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x28, 0x2d },
    { 0x6a, 0x86 },
    { 0x6f, 0x00 },
    { 0x00, 0x00 },
    { 0x04, 0xc6 },
    { 0x0a, 0x03 },
    { 0x31, 0x40 },
    { 0x00, 0x09 },
    { CFG_META_BURST, 4 },
    { 0x34, 0x00 },
    { 0x00, 0x00 },
    { 0x03, 0x00 },
    { CFG_META_BURST, 4 },
    { 0x38, 0x00 },
    { 0x00, 0x00 },
    { 0x02, 0x00 },
};
